/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.registry;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.registry.RegistryEntry;
import org.spongepowered.api.registry.RegistryKey;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.util.annotation.DoNotStore;

@DoNotStore
public interface Registry<T> {
    public RegistryType<T> type();

    public ResourceKey valueKey(T var1);

    public Optional<ResourceKey> findValueKey(T var1);

    public <V extends T> Optional<RegistryEntry<V>> findEntry(ResourceKey var1);

    default public <V extends T> Optional<RegistryEntry<V>> findEntry(RegistryKey<T> key) {
        return this.findEntry(Objects.requireNonNull(key, "key").location());
    }

    public <V extends T> Optional<V> findValue(ResourceKey var1);

    default public <V extends T> Optional<V> findValue(RegistryKey<T> key) {
        return this.findValue(Objects.requireNonNull(key, "key").location());
    }

    public <V extends T> V value(ResourceKey var1);

    default public <V extends T> V value(RegistryKey<T> key) {
        return this.value(Objects.requireNonNull(key, "key").location());
    }

    public Stream<RegistryEntry<T>> streamEntries();

    public Stream<T> stream();

    public boolean isDynamic();

    public <V extends T> Optional<RegistryEntry<V>> register(ResourceKey var1, V var2);
}

