/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.network.channel;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.channel.Channel;
import org.spongepowered.api.network.channel.ChannelException;

@FunctionalInterface
public interface ChannelExceptionHandler<C extends EngineConnection> {
    public static ChannelExceptionHandler<EngineConnection> logEverything() {
        return Sponge.game().factoryProvider().provide(Factory.class).logEverything();
    }

    public void handle(C var1, Channel var2, ChannelException var3, @Nullable CompletableFuture<?> var4);

    default public ChannelExceptionHandler<C> suppressAllIfFutureIsPresent() {
        ChannelExceptionHandler original = this;
        return (connection, channel, exception, future) -> {
            if (future != null) {
                future.completeExceptionally(exception);
            } else {
                original.handle(connection, channel, exception, null);
            }
        };
    }

    default public ChannelExceptionHandler<C> suppressIfFutureIsPresent(Class<? extends ChannelException> exceptionType) {
        Objects.requireNonNull(exceptionType, "exceptionType");
        ChannelExceptionHandler original = this;
        return (connection, channel, exception, future) -> {
            if (future != null && exceptionType.isInstance(exception)) {
                future.completeExceptionally(exception);
            } else {
                original.handle(connection, channel, exception, future);
            }
        };
    }

    default public ChannelExceptionHandler<C> suppress(Class<? extends ChannelException> exceptionType) {
        Objects.requireNonNull(exceptionType, "exceptionType");
        ChannelExceptionHandler original = this;
        return (connection, channel, exception, future) -> {
            if (exceptionType.isInstance(exception)) {
                if (future != null) {
                    future.completeExceptionally(exception);
                }
            } else {
                original.handle(connection, channel, exception, future);
            }
        };
    }

    public static interface Factory {
        public ChannelExceptionHandler<EngineConnection> logEverything();
    }
}

