/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKey;

public interface CauseStackManager {
    public Cause currentCause();

    public EventContext currentContext();

    public CauseStackManager pushCause(Object var1);

    public Object popCause();

    public void popCauses(int var1);

    public Object peekCause();

    public StackFrame pushCauseFrame();

    public void popCauseFrame(StackFrame var1);

    public <T> CauseStackManager addContext(EventContextKey<T> var1, T var2);

    default public <T> CauseStackManager addContext(EventContextKey<T> key, Supplier<? extends T> value) {
        return this.addContext(key, value.get());
    }

    default public <T> CauseStackManager addContext(Supplier<EventContextKey<T>> key, T value) {
        return this.addContext(key.get(), value);
    }

    default public <T> CauseStackManager addContext(Supplier<EventContextKey<T>> key, Supplier<? extends T> value) {
        return this.addContext(key.get(), value.get());
    }

    public <T> Optional<T> context(EventContextKey<T> var1);

    default public <T> Optional<T> context(Supplier<EventContextKey<T>> key) {
        return this.context(key.get());
    }

    default public <T> T requireContext(EventContextKey<T> key) {
        Optional<T> optional = this.context(key);
        if (optional.isPresent()) {
            return optional.get();
        }
        throw new NoSuchElementException(String.format("Could not retrieve value for key '%s'", key.toString()));
    }

    default public <T> T requireContext(Supplier<EventContextKey<T>> key) {
        Optional<T> optional = this.context(key.get());
        if (optional.isPresent()) {
            return optional.get();
        }
        throw new NoSuchElementException(String.format("Could not retrieve value for key '%s'", key.get().toString()));
    }

    public <T> Optional<T> removeContext(EventContextKey<T> var1);

    default public <T> Optional<T> removeContext(Supplier<EventContextKey<T>> key) {
        return this.removeContext(key.get());
    }

    public static interface StackFrame
    extends AutoCloseable {
        public Cause currentCause();

        public EventContext currentContext();

        public StackFrame pushCause(Object var1);

        public Object popCause();

        public <T> StackFrame addContext(EventContextKey<T> var1, T var2);

        default public <T> StackFrame addContext(EventContextKey<T> key, Supplier<? extends T> value) {
            return this.addContext(key, value.get());
        }

        default public <T> StackFrame addContext(Supplier<EventContextKey<T>> key, T value) {
            return this.addContext(key.get(), value);
        }

        default public <T> StackFrame addContext(Supplier<EventContextKey<T>> key, Supplier<? extends T> value) {
            return this.addContext(key.get(), value.get());
        }

        public <T> Optional<T> removeContext(EventContextKey<T> var1);

        default public <T> Optional<T> removeContext(Supplier<EventContextKey<T>> key) {
            return this.removeContext(key.get());
        }

        @Override
        public void close();
    }
}

