/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.value;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.value.Value;

@FunctionalInterface
public interface MergeFunction {
    public static final MergeFunction REPLACEMENT_PREFERRED = new MergeFunction(){

        @Override
        public <V extends Value<E>, E> V merge(@Nullable V original, @Nullable V replacement) {
            return replacement == null ? Objects.requireNonNull(original, "Original and replacement cannot be null!") : replacement;
        }
    };
    public static final MergeFunction ORIGINAL_PREFERRED = new MergeFunction(){

        @Override
        public <V extends Value<E>, E> V merge(@Nullable V original, @Nullable V replacement) {
            return original == null ? Objects.requireNonNull(replacement, "Replacement and original cannot be null!") : original;
        }
    };

    public <V extends Value<E>, E> V merge(@Nullable V var1, @Nullable V var2);

    default public MergeFunction andThen(final MergeFunction that) {
        final MergeFunction self = this;
        return new MergeFunction(){

            @Override
            public <V extends Value<E>, E> V merge(@Nullable V original, @Nullable V replacement) {
                return that.merge(self.merge(original, replacement), replacement);
            }
        };
    }
}

