/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.server.storage;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.key.KeyedValue;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKeyed;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.trader.WanderingTrader;
import org.spongepowered.api.util.Builder;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.util.MinecraftDayTime;
import org.spongepowered.api.util.Nameable;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.border.WorldBorder;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.gamerule.GameRuleHolder;
import org.spongepowered.api.world.generation.config.WorldGenerationConfig;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.WorldArchetype;
import org.spongepowered.api.world.server.WorldArchetypeType;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.api.world.weather.Weather;
import org.spongepowered.api.world.weather.WeatherUniverse;

public interface ServerWorldProperties
extends WorldProperties,
GameRuleHolder,
Nameable,
Identifiable,
ResourceKeyed,
WeatherUniverse.Mutable {
    public Optional<ServerWorld> world();

    default public Optional<Component> displayName() {
        return this.get(Keys.DISPLAY_NAME);
    }

    default public void setDisplayName(@Nullable Component name) {
        this.offer(Keys.DISPLAY_NAME, name);
    }

    default public boolean initialized() {
        return this.require(Keys.INITIALIZED);
    }

    default public boolean loadOnStartup() {
        return this.require(Keys.IS_LOAD_ON_STARTUP);
    }

    default public void setLoadOnStartup(boolean loadOnStartup) {
        this.offer(Keys.IS_LOAD_ON_STARTUP, Boolean.valueOf(loadOnStartup));
    }

    default public boolean performsSpawnLogic() {
        return this.require(Keys.PERFORM_SPAWN_LOGIC);
    }

    default public void setPerformsSpawnLogic(boolean performsSpawnLogic) {
        this.offer(Keys.PERFORM_SPAWN_LOGIC, Boolean.valueOf(performsSpawnLogic));
    }

    default public WorldGenerationConfig worldGenerationConfig() {
        return this.require(Keys.WORLD_GEN_CONFIG);
    }

    public void setDayTime(MinecraftDayTime var1);

    default public WorldType worldType() {
        return this.require(Keys.WORLD_TYPE);
    }

    default public void setWorldType(WorldType worldType) {
        this.offer(Keys.WORLD_TYPE, worldType);
    }

    default public boolean pvp() {
        return this.require(Keys.PVP);
    }

    default public void setPvp(boolean pvp) {
        this.offer(Keys.PVP, Boolean.valueOf(pvp));
    }

    default public GameMode gameMode() {
        return this.require(Keys.GAME_MODE);
    }

    default public void setGameMode(GameMode gameMode) {
        this.offer(Keys.GAME_MODE, gameMode);
    }

    default public void setHardcore(boolean hardcore) {
        this.offer(Keys.HARDCORE, Boolean.valueOf(hardcore));
    }

    default public boolean commands() {
        return this.require(Keys.COMMANDS);
    }

    default public void setCommands(boolean commands) {
        this.offer(Keys.COMMANDS, Boolean.valueOf(commands));
    }

    default public void setDifficulty(Difficulty difficulty) {
        this.offer(Keys.WORLD_DIFFICULTY, difficulty);
    }

    default public SerializationBehavior serializationBehavior() {
        return this.require(Keys.SERIALIZATION_BEHAVIOR);
    }

    default public void setSerializationBehavior(SerializationBehavior behavior) {
        this.offer(Keys.SERIALIZATION_BEHAVIOR, behavior);
    }

    public Ticks wanderingTraderSpawnDelay();

    public void setWanderingTraderSpawnDelay(Ticks var1);

    public int wanderingTraderSpawnChance();

    public void setWanderingTraderSpawnChance(int var1);

    public Optional<UUID> wanderTraderUniqueId();

    public void setWanderingTrader(@Nullable WanderingTrader var1);

    public List<KeyedValue<BossBar>> customBossBars();

    public void setCustomBossBars(@Nullable List<KeyedValue<BossBar>> var1);

    default public int viewDistance() {
        return this.require(Keys.VIEW_DISTANCE);
    }

    default public void setViewDistance(@Nullable Integer viewDistance) {
        this.offer(Keys.VIEW_DISTANCE, viewDistance);
    }

    default public WorldBorder worldBorder() {
        return this.require(Keys.WORLD_BORDER);
    }

    @Override
    default public Weather weather() {
        return this.require(Keys.WEATHER);
    }

    default public WorldArchetypeType worldArchetypeType() {
        return this.require(Keys.WORLD_ARCHETYPE_TYPE);
    }

    default public WorldArchetype worldArchetype() {
        return this.require(Keys.WORLD_ARCHETYPE);
    }

    public static interface LoadOptions {
        public static Builder builder() {
            return Sponge.game().builderProvider().provide(Builder.class);
        }

        public static LoadOptions load() {
            return (LoadOptions)LoadOptions.builder().load().build();
        }

        public static LoadOptions load(Consumer<ServerWorldProperties> loadCallback) {
            return (LoadOptions)LoadOptions.builder().load().loadCallback(loadCallback).build();
        }

        public static LoadOptions get() {
            return (LoadOptions)LoadOptions.builder().get().build();
        }

        public static LoadOptions get(Consumer<ServerWorldProperties> getCallback) {
            return (LoadOptions)LoadOptions.builder().get().getCallback(getCallback).build();
        }

        public static LoadOptions getOrLoad() {
            return (LoadOptions)LoadOptions.builder().get().load().build();
        }

        public static LoadOptions getOrLoad(Consumer<ServerWorldProperties> getCallback, Consumer<ServerWorldProperties> loadCallback) {
            return (LoadOptions)LoadOptions.builder().get().getCallback(getCallback).load().loadCallback(loadCallback).build();
        }

        public static LoadOptions create(WorldArchetype worldArchetype) {
            return (LoadOptions)LoadOptions.builder().create(worldArchetype).build();
        }

        public static LoadOptions create(WorldArchetype worldArchetype, Consumer<ServerWorldProperties> createCallback) {
            return (LoadOptions)LoadOptions.builder().create(worldArchetype).createCallback(createCallback).build();
        }

        public Optional<GetOperation> getOperation();

        public Optional<LoadOperation> loadOperation();

        public Optional<CreateOperation> createOperation();

        public static interface Builder
        extends org.spongepowered.api.util.Builder<LoadOptions, Builder> {
            public GetStep get();

            public LoadStep load();

            public CreateStep create(WorldArchetype var1);

            public static interface CreateStep
            extends Builder {
                public CreateStep createCallback(Consumer<ServerWorldProperties> var1);
            }

            public static interface LoadStep
            extends Builder {
                public LoadStep overrideWorldArchetype(WorldArchetype var1);

                public LoadStep fallbackWorldArchetype(WorldArchetype var1);

                public LoadStep loadCallback(Consumer<ServerWorldProperties> var1);
            }

            public static interface GetStep
            extends Builder {
                public GetStep getCallback(Consumer<ServerWorldProperties> var1);
            }
        }

        public static interface CreateOperation {
            public WorldArchetype worldArchetype();

            public Optional<Consumer<ServerWorldProperties>> createCallback();
        }

        public static interface LoadOperation {
            public Optional<WorldArchetype> overrideWorldArchetype();

            public Optional<WorldArchetype> fallbackWorldArchetype();

            public Optional<Consumer<ServerWorldProperties>> loadCallback();
        }

        public static interface GetOperation {
            public Optional<Consumer<ServerWorldProperties>> getCallback();
        }
    }
}

