/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.portal;

import java.util.Optional;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.util.Axis;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.world.portal.Portal;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public interface PortalLogic {
    public static Builder builder() {
        return Sponge.game().builderProvider().provide(Builder.class);
    }

    public static Factory factory() {
        return Sponge.game().factoryProvider().provide(Factory.class);
    }

    public Optional<PortalExitCalculator> exitCalculator();

    public Optional<PortalFinder> finder();

    public Optional<PortalGenerator> generator();

    public boolean teleport(Entity var1, ServerLocation var2, boolean var3);

    public static interface Builder
    extends ResettableBuilder<PortalLogic, Builder> {
        default public Builder addSimplePortal(PortalExitCalculator calulator) {
            return this.addPortalWithFinder(calulator, PortalLogic.factory().noOpFinder());
        }

        default public Builder addPortalWithFinder(PortalExitCalculator calulator, PortalFinder finder) {
            return this.addPortal(calulator, finder, (at, axis) -> Optional.empty());
        }

        default public Builder addPortalWithGenerator(PortalExitCalculator calulator, PortalGenerator generator) {
            return this.addPortal(calulator, (at, r) -> Optional.empty(), generator);
        }

        public Builder addPortal(PortalExitCalculator var1, PortalFinder var2, PortalGenerator var3);

        public <T extends PortalExitCalculator & PortalFinder> Builder addPortal(T var1);

        public PortalLogic build();
    }

    public static interface Factory {
        public PortalLogic endPortal();

        public PortalLogic endGateway();

        public PortalLogic netherPortal();

        public PortalExitCalculator netherPortalExitCalculator(ResourceKey var1, ResourceKey var2);

        public PortalExitCalculator netherPortalExitCalculator(ResourceKey var1, ResourceKey var2, double var3);

        public PortalFinder netherPortalFinder();

        public PortalGenerator netherPortalGenerator();

        public PortalGenerator endPlatformGenerator();

        public PortalExitCalculator targetCalculator(ResourceKey var1, ResourceKey var2, Vector3d var3);

        public PortalExitCalculator spawnCalculator(ResourceKey var1, ResourceKey var2);

        public PortalFinder noOpFinder();

        public Portal portalOf(PortalLogic var1, ServerLocation var2);

        public Portal portalOf(PortalLogic var1, ServerLocation var2, AABB var3);
    }

    @FunctionalInterface
    public static interface PortalGenerator {
        public Optional<Portal> generatePortal(ServerLocation var1, Axis var2);
    }

    @FunctionalInterface
    public static interface PortalFinder {
        public Optional<Portal> findPortal(ServerLocation var1, int var2);
    }

    @FunctionalInterface
    public static interface PortalExitCalculator {
        public Optional<ServerLocation> calculatePortalExit(ServerWorld var1, Vector3i var2, Entity var3);
    }
}

