/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.generation;

import java.util.Objects;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Server;
import org.spongepowered.api.world.WorldLike;
import org.spongepowered.api.world.generation.GenerationChunk;
import org.spongepowered.math.vector.Vector3i;

public interface GenerationRegion
extends WorldLike<GenerationRegion> {
    public ResourceKey worldKey();

    @Override
    public Server engine();

    public Vector3i chunkMin();

    public Vector3i chunkMax();

    default public GenerationChunk chunkAtBlock(Vector3i position) {
        Objects.requireNonNull(position, "position");
        return this.chunkAtBlock(position.x(), position.y(), position.z());
    }

    default public GenerationChunk chunkAtBlock(int x, int y, int z) {
        return this.chunk(this.engine().chunkLayout().toChunk(x, y, z).orElseThrow(() -> new IllegalArgumentException(String.format("Cannot convert (%s, %s, %s) to chunk coordinates.", x, y, z))));
    }

    default public GenerationChunk chunk(Vector3i chunkPosition) {
        Objects.requireNonNull(chunkPosition, "chunkPosition");
        return this.chunk(chunkPosition.x(), chunkPosition.y(), chunkPosition.z());
    }

    public GenerationChunk chunk(int var1, int var2, int var3);
}

