/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.biome.provider;

import java.util.List;
import java.util.Objects;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.biome.BiomeFinder;
import org.spongepowered.api.world.biome.provider.CheckerboardBiomeConfig;
import org.spongepowered.api.world.biome.provider.ConfigurableBiomeProvider;
import org.spongepowered.api.world.biome.provider.EndStyleBiomeConfig;
import org.spongepowered.api.world.biome.provider.FixedBiomeProvider;
import org.spongepowered.api.world.biome.provider.MultiNoiseBiomeConfig;

public interface BiomeProvider
extends BiomeFinder {
    public static ConfigurableBiomeProvider<MultiNoiseBiomeConfig> overworld() {
        return Sponge.game().factoryProvider().provide(Factory.class).overworld();
    }

    public static ConfigurableBiomeProvider<MultiNoiseBiomeConfig> multiNoise(MultiNoiseBiomeConfig config) {
        return Sponge.game().factoryProvider().provide(Factory.class).multiNoise(config);
    }

    public static ConfigurableBiomeProvider<MultiNoiseBiomeConfig> nether() {
        return Sponge.game().factoryProvider().provide(Factory.class).nether();
    }

    public static ConfigurableBiomeProvider<EndStyleBiomeConfig> endStyle(EndStyleBiomeConfig config) {
        return Sponge.game().factoryProvider().provide(Factory.class).endStyle(config);
    }

    public static ConfigurableBiomeProvider<EndStyleBiomeConfig> end() {
        return Sponge.game().factoryProvider().provide(Factory.class).end();
    }

    public static ConfigurableBiomeProvider<CheckerboardBiomeConfig> checkerboard(CheckerboardBiomeConfig config) {
        return Sponge.game().factoryProvider().provide(Factory.class).checkerboard(config);
    }

    public static FixedBiomeProvider fixed(RegistryReference<Biome> biome) {
        return Sponge.game().factoryProvider().provide(Factory.class).fixed(Objects.requireNonNull(biome, "biome"));
    }

    public List<Biome> choices();

    public static interface Factory {
        public ConfigurableBiomeProvider<MultiNoiseBiomeConfig> overworld();

        public ConfigurableBiomeProvider<MultiNoiseBiomeConfig> multiNoise(MultiNoiseBiomeConfig var1);

        public ConfigurableBiomeProvider<MultiNoiseBiomeConfig> nether();

        public ConfigurableBiomeProvider<EndStyleBiomeConfig> endStyle(EndStyleBiomeConfig var1);

        public ConfigurableBiomeProvider<EndStyleBiomeConfig> end();

        public ConfigurableBiomeProvider<CheckerboardBiomeConfig> checkerboard(CheckerboardBiomeConfig var1);

        public FixedBiomeProvider fixed(RegistryReference<Biome> var1);
    }
}

