/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world;

import java.util.Optional;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public interface Location<W extends World<W, L>, L extends Location<W, L>> {
    public W world();

    public Optional<W> worldIfAvailable();

    public boolean isAvailable();

    public boolean isValid();

    public Vector3d position();

    public Vector3i blockPosition();

    public Vector3i chunkPosition();

    public Vector3i biomePosition();

    public double x();

    public double y();

    public double z();

    public int blockX();

    public int blockY();

    public int blockZ();

    default public Optional<ServerLocation> onServer() {
        return Optional.ofNullable(this instanceof ServerLocation ? (ServerLocation)this : null);
    }

    public boolean inWorld(W var1);

    public L withWorld(W var1);

    public L withPosition(Vector3d var1);

    public L withBlockPosition(Vector3i var1);

    public L sub(Vector3d var1);

    public L sub(Vector3i var1);

    public L sub(double var1, double var3, double var5);

    public L add(Vector3d var1);

    public L add(Vector3i var1);

    public L add(double var1, double var3, double var5);

    public L relativeTo(Direction var1);

    public L relativeToBlock(Direction var1);

    public Biome biome();

    public boolean hasBlock();

    public BlockState block();

    default public BlockType blockType() {
        return this.block().type();
    }

    public FluidState fluid();

    public boolean hasBlockEntity();

    public Optional<? extends BlockEntity> blockEntity();

    public boolean setBlock(BlockState var1);

    public boolean setBlock(BlockState var1, BlockChangeFlag var2);

    public boolean setBlockType(BlockType var1);

    public boolean setBlockType(BlockType var1, BlockChangeFlag var2);
}

