/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util.weighted;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.random.RandomGenerator;
import org.spongepowered.api.util.weighted.NestedTableEntry;
import org.spongepowered.api.util.weighted.RandomObjectTable;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedObject;

public class WeightedTable<T>
extends RandomObjectTable<T> {
    private double totalWeight = 0.0;

    public WeightedTable() {
        super(1);
    }

    public WeightedTable(int rolls) {
        super(rolls);
    }

    public WeightedTable(VariableAmount rolls) {
        super(rolls);
    }

    @Override
    public boolean add(TableEntry<T> entry) {
        boolean added = super.add(entry);
        if (added) {
            this.recalculateWeight();
        }
        return added;
    }

    @Override
    public boolean add(T object, double weight) {
        boolean added = super.add(object, weight);
        if (added) {
            this.recalculateWeight();
        }
        return added;
    }

    @Override
    public boolean addAll(Collection<? extends TableEntry<T>> c) {
        boolean added = super.addAll(c);
        if (added) {
            this.recalculateWeight();
        }
        return added;
    }

    @Override
    public boolean remove(Object entry) {
        boolean removed = super.remove(entry);
        if (removed) {
            this.recalculateWeight();
        }
        return removed;
    }

    @Override
    public boolean removeObject(Object entry) {
        boolean removed = super.removeObject(entry);
        if (removed) {
            this.recalculateWeight();
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removed = super.removeAll(c);
        if (removed) {
            this.recalculateWeight();
        }
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean removed = super.retainAll(c);
        if (removed) {
            this.recalculateWeight();
        }
        return removed;
    }

    @Override
    public void clear() {
        super.clear();
        this.recalculateWeight();
    }

    protected void recalculateWeight() {
        this.totalWeight = 0.0;
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            TableEntry entry = (TableEntry)it.next();
            if (entry.weight() < 0.0) {
                it.remove();
                continue;
            }
            this.totalWeight += entry.weight();
        }
    }

    @Override
    public List<T> get(RandomGenerator rand) {
        ArrayList results = new ArrayList();
        if (this.entries.isEmpty()) {
            return results;
        }
        int rolls = this.rolls().flooredAmount(rand);
        block0: for (int i = 0; i < rolls; ++i) {
            double roll = rand.nextDouble() * this.totalWeight;
            for (TableEntry next : this.entries) {
                if (!((roll -= next.weight()) <= 0.0)) continue;
                if (next instanceof NestedTableEntry) {
                    results.addAll(((NestedTableEntry)next).get(rand));
                    continue block0;
                }
                if (!(next instanceof WeightedObject)) continue block0;
                results.add(((WeightedObject)next).get());
                continue block0;
            }
        }
        return results;
    }

    @Override
    public Iterator<TableEntry<T>> iterator() {
        return new Itr();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeightedTable)) {
            return false;
        }
        WeightedTable c = (WeightedTable)o;
        if (this.rolls() != c.rolls()) {
            return false;
        }
        if (this.entries.size() != c.entries.size()) {
            return false;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            if (((TableEntry)this.entries.get(i)).equals(c.entries.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int r = 1;
        r = r * 37 + this.rolls().hashCode();
        for (TableEntry entry : this.entries) {
            r = r * 37 + entry.hashCode();
        }
        return r;
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("WeightedTable (rolls=").append(this.rolls());
        r.append(",entries=").append(this.entries.size()).append(") {\n");
        for (TableEntry entry : this.entries) {
            r.append("\t").append(entry.toString()).append("\n");
        }
        r.append("}");
        return r.toString();
    }

    private class Itr
    implements Iterator<TableEntry<T>> {
        private final Iterator<TableEntry<T>> iter;

        protected Itr() {
            this.iter = WeightedTable.super.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public TableEntry<T> next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            this.iter.remove();
            WeightedTable.this.recalculateWeight();
        }
    }
}

