/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util.weighted;

import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.random.RandomGenerator;
import org.spongepowered.api.util.weighted.RandomObjectTable;
import org.spongepowered.api.util.weighted.TableEntry;

public class NestedTableEntry<T>
extends TableEntry<T> {
    private final RandomObjectTable<T> table;

    public NestedTableEntry(double weight, RandomObjectTable<T> table) {
        super(weight);
        this.table = Objects.requireNonNull(table);
    }

    public List<T> get(RandomGenerator rand) {
        return this.table.get(rand);
    }

    public RandomObjectTable<T> getNestedTable() {
        return this.table;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NestedTableEntry)) {
            return false;
        }
        NestedTableEntry c = (NestedTableEntry)o;
        return this.table.equals(c.table);
    }

    public int hashCode() {
        int r = 1;
        long w = Double.doubleToLongBits(this.weight());
        r = r * 37 + (int)(w ^ w >>> 32);
        r = r * 37 + this.table.hashCode();
        return r;
    }

    public String toString() {
        return new StringJoiner(", ", NestedTableEntry.class.getSimpleName() + "[", "]").add("table=" + String.valueOf(this.table)).toString();
    }
}

