/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.resource;

import java.util.Optional;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.plugin.PluginContainer;

public interface ResourcePath
extends Comparable<ResourcePath> {
    public static ResourcePath of(String namespace, String path) {
        return ResourcePath.of(ResourceKey.of(namespace, path));
    }

    public static ResourcePath of(PluginContainer container, String path) {
        return ResourcePath.of(ResourceKey.of(container, path));
    }

    public static ResourcePath parse(String value) {
        return ResourcePath.of(ResourceKey.resolve(value));
    }

    public static ResourcePath of(ResourceKey key) {
        return Sponge.game().factoryProvider().provide(Factory.class).of(key);
    }

    public ResourceKey key();

    default public String namespace() {
        return this.key().namespace();
    }

    default public String path() {
        return this.key().value();
    }

    public Optional<ResourcePath> parent();

    public ResourcePath resolve(String var1, String ... var2);

    public ResourcePath resolveSibling(String var1, String ... var2);

    public String name();

    public String baseName();

    public String extension();

    public static interface Factory {
        public ResourcePath of(ResourceKey var1);
    }
}

