/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.network.channel.raw.play;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.EngineConnectionState;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.api.network.channel.raw.RawDataChannel;
import org.spongepowered.api.network.channel.raw.play.RawPlayDataHandler;
import org.spongepowered.api.world.server.ServerWorld;

public interface RawPlayDataChannel {
    public RawDataChannel parent();

    public boolean isSupportedBy(EngineConnection var1);

    public void addHandler(RawPlayDataHandler<EngineConnectionState> var1);

    public <S extends EngineConnectionState> void addHandler(Class<S> var1, RawPlayDataHandler<? super S> var2);

    public <S extends EngineConnectionState> void removeHandler(Class<S> var1, RawPlayDataHandler<? super S> var2);

    public void removeHandler(RawPlayDataHandler<?> var1);

    default public void sendToAllPlayers(Consumer<ChannelBuf> payload) {
        Sponge.server().streamOnlinePlayers().forEach(player -> this.sendTo((ServerPlayer)player, payload));
    }

    default public void sendToAllPlayersIn(ServerWorld world, Consumer<ChannelBuf> payload) {
        world.players().forEach(player -> this.sendTo((ServerPlayer)player, payload));
    }

    default public CompletableFuture<Void> sendTo(ServerPlayer player, Consumer<ChannelBuf> payload) {
        return this.sendTo(player.connection(), payload);
    }

    default public CompletableFuture<Void> sendToServer(Consumer<ChannelBuf> payload) {
        EngineConnection connection = Sponge.client().connection().orElseThrow(() -> new IllegalStateException("The client is currently not connected to a server."));
        return this.sendTo(connection, payload);
    }

    public CompletableFuture<Void> sendTo(EngineConnection var1, Consumer<ChannelBuf> var2);
}

