/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.recipe.crafting;

import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;

public final class RecipeResult {
    private final ItemStackSnapshot result;
    private final List<ItemStackSnapshot> remainingItems;

    public RecipeResult(ItemStackLike result, List<? extends ItemStackLike> remainingItems) {
        Objects.requireNonNull(result, "result");
        if (result.isEmpty()) {
            throw new IllegalArgumentException("The result must not be empty!");
        }
        Objects.requireNonNull(remainingItems, "remainingItems");
        if (remainingItems.isEmpty()) {
            throw new IllegalArgumentException("The remainingItems list must not be empty. It should contain empty ItemStackSnapshot values for slots which should be cleared.");
        }
        this.result = result.asImmutable();
        this.remainingItems = remainingItems.stream().map(ItemStackLike::asImmutable).toList();
    }

    public ItemStackSnapshot result() {
        return this.result;
    }

    public List<ItemStackSnapshot> remainingItems() {
        return this.remainingItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecipeResult that = (RecipeResult)o;
        return this.result.equals(that.result) && this.remainingItems.equals(that.remainingItems);
    }

    public int hashCode() {
        int result1 = this.result.hashCode();
        result1 = 31 * result1 + this.remainingItems.hashCode();
        return result1;
    }

    public String toString() {
        return new StringJoiner(", ", RecipeResult.class.getSimpleName() + "[", "]").add("result=" + String.valueOf(this.result)).add("remainingItems=" + String.valueOf(this.remainingItems)).toString();
    }
}

