/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.recipe.crafting;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.registry.DefaultedRegistryReference;

public interface Ingredient
extends Predicate<ItemStack> {
    public static Ingredient empty() {
        return Sponge.game().factoryProvider().provide(Factory.class).empty();
    }

    @Override
    public boolean test(ItemStackLike var1);

    public List<ItemStackSnapshot> displayedItems();

    public static Builder builder() {
        return Sponge.game().builderProvider().provide(Builder.class);
    }

    public static Ingredient of(ItemType ... itemTypes) {
        if (itemTypes == null || itemTypes.length == 0) {
            return Ingredient.empty();
        }
        return Ingredient.builder().with(itemTypes).build();
    }

    @SafeVarargs
    public static Ingredient of(DefaultedRegistryReference<? extends ItemType> ... itemTypes) {
        if (itemTypes == null || itemTypes.length == 0) {
            return Ingredient.empty();
        }
        return Ingredient.builder().with(itemTypes).build();
    }

    public static Ingredient of(ItemStackLike ... items) {
        if (items == null) {
            return Ingredient.empty();
        }
        return Ingredient.builder().with(items).build();
    }

    public static Ingredient of(ResourceKey key, Predicate<? super ItemStackLike> predicate, ItemStackLike ... exemplaryStacks) {
        if (exemplaryStacks.length == 0) {
            throw new IllegalArgumentException("At least exemplary stack is required");
        }
        return Ingredient.builder().with(key, predicate, exemplaryStacks).build();
    }

    public static Ingredient of(ResourceKey key) {
        return Ingredient.builder().with(key).build();
    }

    public static interface Factory {
        public Ingredient empty();
    }

    public static interface Builder
    extends org.spongepowered.api.util.Builder<Ingredient, Builder> {
        public Builder with(ItemType ... var1);

        public Builder with(Supplier<? extends ItemType> ... var1);

        public Builder with(ItemStackLike ... var1);

        public Builder with(ResourceKey var1, Predicate<? super ItemStackLike> var2, ItemStackLike ... var3);

        public Builder with(ResourceKey var1);

        public Ingredient build();
    }
}

