/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.recipe;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.recipe.Recipe;
import org.spongepowered.api.item.recipe.RecipeType;
import org.spongepowered.api.item.recipe.cooking.CookingRecipe;
import org.spongepowered.api.item.recipe.crafting.RecipeInput;
import org.spongepowered.api.world.server.ServerWorld;

public interface RecipeManager {
    public Optional<Recipe<?>> byKey(ResourceKey var1);

    public Collection<Recipe<?>> all();

    public <T extends Recipe<?>> Collection<T> allOfType(RecipeType<T> var1);

    default public <T extends Recipe<?>> Collection<T> allOfType(Supplier<? extends RecipeType<T>> supplier) {
        return this.allOfType(supplier.get());
    }

    public <T extends Recipe<?>> Collection<T> findByResult(RecipeType<T> var1, ItemStackLike var2);

    default public <T extends Recipe<?>> Collection<T> findByResult(Supplier<? extends RecipeType<T>> supplier, ItemStackLike result) {
        return this.findByResult(supplier.get(), result);
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<T> findMatchingRecipe(RecipeType<T> var1, I var2, ServerWorld var3);

    default public <I extends RecipeInput, T extends Recipe<I>> Optional<T> findMatchingRecipe(Supplier<? extends RecipeType<T>> supplier, I input, ServerWorld world) {
        return this.findMatchingRecipe(supplier.get(), input, world);
    }

    public <T extends CookingRecipe> Optional<T> findCookingRecipe(RecipeType<T> var1, ItemStackLike var2);

    default public <T extends CookingRecipe> Optional<T> findCookingRecipe(Supplier<? extends RecipeType<T>> supplier, ItemStackLike ingredient) {
        return this.findCookingRecipe(supplier.get(), ingredient);
    }
}

