/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.recipe;

import java.util.List;
import java.util.Optional;
import org.spongepowered.api.datapack.DataPackSerializable;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.RecipeType;
import org.spongepowered.api.item.recipe.crafting.RecipeInput;
import org.spongepowered.api.item.recipe.crafting.RecipeResult;
import org.spongepowered.api.registry.DefaultedRegistryValue;
import org.spongepowered.api.world.server.ServerWorld;

public interface Recipe<T extends RecipeInput>
extends DefaultedRegistryValue<Recipe<?>>,
DataPackSerializable {
    public boolean isValid(T var1, ServerWorld var2);

    public ItemStackSnapshot result(T var1);

    public ItemStackSnapshot exemplaryResult();

    public List<ItemStackSnapshot> remainingItems(T var1);

    default public Optional<RecipeResult> result(T inventory, ServerWorld world) {
        if (this.isValid(inventory, world)) {
            return Optional.of(new RecipeResult(this.result(inventory), this.remainingItems(inventory)));
        }
        return Optional.empty();
    }

    public boolean isDynamic();

    public RecipeType<? extends Recipe<?>> type();
}

