/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.inventory.transaction;

import java.util.List;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.util.CopyableBuilder;

public interface InventoryTransactionResult {
    public static Builder builder() {
        return Sponge.game().builderProvider().provide(Builder.class);
    }

    public static InventoryTransactionResult successNoTransactions() {
        return InventoryTransactionResult.builder().type(Type.SUCCESS).build();
    }

    public static InventoryTransactionResult failNoTransactions() {
        return InventoryTransactionResult.builder().type(Type.ERROR).build();
    }

    public InventoryTransactionResult and(InventoryTransactionResult var1);

    public void revert();

    public boolean revertOnFailure();

    public Type type();

    public List<ItemStackSnapshot> rejectedItems();

    public List<ItemStackSnapshot> polledItems();

    public List<SlotTransaction> slotTransactions();

    public static interface Builder
    extends org.spongepowered.api.util.Builder<InventoryTransactionResult, Builder>,
    CopyableBuilder<InventoryTransactionResult, Builder> {
        public Builder type(Type var1);

        public Builder reject(ItemStackLike ... var1);

        public Builder reject(Iterable<? extends ItemStackLike> var1);

        public PollBuilder poll(ItemStackLike var1);

        public Builder transaction(SlotTransaction ... var1);

        public Builder transaction(Iterable<SlotTransaction> var1);

        public InventoryTransactionResult build();

        public static interface PollBuilder
        extends Builder {
            @Override
            public Poll build();
        }
    }

    public static enum Type {
        SUCCESS,
        FAILURE,
        ERROR,
        NO_SLOT;

    }

    public static interface Poll
    extends InventoryTransactionResult {
        public ItemStackSnapshot polledItem();
    }
}

