/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.inventory;

import java.util.Collection;
import java.util.function.Supplier;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.SerializableDataHolder;
import org.spongepowered.api.entity.attribute.AttributeModifier;
import org.spongepowered.api.entity.attribute.type.AttributeType;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.registry.DefaultedRegistryReference;

public interface ItemStackLike
extends SerializableDataHolder,
ComponentLike,
HoverEventSource<HoverEvent.ShowItem> {
    public ItemType type();

    public int quantity();

    default public int maxStackQuantity() {
        return this.require(Keys.MAX_STACK_SIZE);
    }

    public boolean isEmpty();

    default public Collection<AttributeModifier> attributeModifiers(Supplier<? extends AttributeType> attributeType, DefaultedRegistryReference<? extends EquipmentType> equipmentType) {
        return this.attributeModifiers(attributeType.get(), equipmentType.get());
    }

    default public Collection<AttributeModifier> attributeModifiers(AttributeType attributeType, DefaultedRegistryReference<? extends EquipmentType> equipmentType) {
        return this.attributeModifiers(attributeType, equipmentType.get());
    }

    default public Collection<AttributeModifier> attributeModifiers(Supplier<? extends AttributeType> attributeType, EquipmentType equipmentType) {
        return this.attributeModifiers(attributeType.get(), equipmentType);
    }

    public Collection<AttributeModifier> attributeModifiers(AttributeType var1, EquipmentType var2);

    public ItemStack asMutable();

    public ItemStack asMutableCopy();

    public ItemStackSnapshot asImmutable();

    @Override
    public ItemStackLike copy();
}

