/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.inventory;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.random.RandomGenerator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.value.ListValue;
import org.spongepowered.api.data.value.SetValue;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedTable;

public final class ItemStackBuilderPopulators {
    public static BiConsumer<ItemStack.Builder, Random> itemStack(ItemStackSnapshot snapshot) {
        Objects.requireNonNull(snapshot, "ItemStackSnapshot cannot be null!");
        return (builder, random) -> builder.fromSnapshot(snapshot);
    }

    public static BiConsumer<ItemStack.Builder, Random> itemStacks(ItemStackSnapshot snapshot, ItemStackSnapshot ... snapshots) {
        Objects.requireNonNull(snapshot, "ItemStackSnapshot cannot be null!");
        WeightedTable<ItemStackSnapshot> table = new WeightedTable<ItemStackSnapshot>(1);
        table.add(snapshot, 1.0);
        for (ItemStackSnapshot stackSnapshot : snapshots) {
            table.add(Objects.requireNonNull(stackSnapshot, "ItemStackSnapshot cannot be null!"), 1.0);
        }
        return (builder, random) -> builder.fromSnapshot((ItemStackSnapshot)table.get((RandomGenerator)random).get(0));
    }

    public static BiConsumer<ItemStack.Builder, Random> item(ItemType itemType) {
        Objects.requireNonNull(itemType, "ItemType cannot be null!");
        return (builder, random) -> builder.itemType(itemType);
    }

    public static BiConsumer<ItemStack.Builder, Random> item(Supplier<? extends ItemType> supplier) {
        Objects.requireNonNull(supplier, "Supplier cannot be null!");
        return (builder, random) -> builder.itemType(Objects.requireNonNull((ItemType)supplier.get(), "Supplier returned a null ItemType"));
    }

    public static BiConsumer<ItemStack.Builder, Random> items(ItemType itemType, ItemType ... itemTypes) {
        return ItemStackBuilderPopulators.items(Stream.concat(Stream.of(itemType), Arrays.stream(itemTypes)).collect(Collectors.toUnmodifiableList()));
    }

    public static BiConsumer<ItemStack.Builder, Random> items(Collection<ItemType> itemTypes) {
        List<ItemType> copiedItemTypes = List.copyOf(itemTypes);
        return (builder, random) -> builder.itemType((ItemType)copiedItemTypes.get(random.nextInt(copiedItemTypes.size())));
    }

    public static BiConsumer<ItemStack.Builder, Random> quantity(VariableAmount amount) {
        Objects.requireNonNull(amount, "VariableAmount cannot be null!");
        return (builder, random) -> builder.quantity(amount.flooredAmount((RandomGenerator)random));
    }

    public static BiConsumer<ItemStack.Builder, Random> quantity(Supplier<VariableAmount> supplier) {
        Objects.requireNonNull(supplier, "Supplier cannot be null!");
        return (builder, random) -> builder.quantity(((VariableAmount)supplier.get()).flooredAmount((RandomGenerator)random));
    }

    public static <E> BiConsumer<ItemStack.Builder, Random> keyValue(Key<? extends Value<E>> key, E value) {
        return (builder, random) -> {
            ItemStack itemStack = builder.build();
            DataTransactionResult dataTransactionResult = itemStack.offer(key, value);
            if (dataTransactionResult.isSuccessful()) {
                builder.from(itemStack);
            }
        };
    }

    public static <E> BiConsumer<ItemStack.Builder, Random> keyValues(Key<? extends Value<E>> key, Iterable<E> values) {
        Objects.requireNonNull(values, "Iterable cannot be null!");
        Objects.requireNonNull(key, "Key cannot be null!");
        WeightedTable tableEntries = new WeightedTable(1);
        for (E e : values) {
            tableEntries.add(Objects.requireNonNull(e, "Value cannot be null!"), 1.0);
        }
        return (builder, random) -> {
            ItemStack itemStack = builder.build();
            DataTransactionResult dataTransactionResult = itemStack.offer(key, tableEntries.get((RandomGenerator)random).get(0));
            if (dataTransactionResult.isSuccessful()) {
                builder.from(itemStack);
            }
        };
    }

    public static <E> BiConsumer<ItemStack.Builder, Random> listValues(Key<? extends ListValue.Mutable<E>> key, List<E> elementPool, VariableAmount amount) {
        Objects.requireNonNull(key, "Key cannot be null!");
        Objects.requireNonNull(elementPool, "Element pool cannot be null!");
        Objects.requireNonNull(amount, "VariableAmount cannot be null!");
        if (elementPool.isEmpty()) {
            throw new IllegalArgumentException("Element pool cannot be empty!");
        }
        WeightedTable<E> elementTable = new WeightedTable<E>(amount);
        for (E element : elementPool) {
            elementTable.add(Objects.requireNonNull(element, "Element cannot be null!"), 1.0);
        }
        return ItemStackBuilderPopulators.listValues(key, elementTable);
    }

    public static <E> BiConsumer<ItemStack.Builder, Random> listValues(Key<? extends ListValue.Mutable<E>> key, List<E> elementPool) {
        return ItemStackBuilderPopulators.listValues(key, elementPool, VariableAmount.baseWithRandomAddition(1.0, elementPool.size() - 1));
    }

    public static <E> BiConsumer<ItemStack.Builder, Random> listValues(Key<? extends ListValue.Mutable<E>> key, WeightedTable<E> weightedTable) {
        Objects.requireNonNull(weightedTable, "Weighted table cannot be null!");
        Objects.requireNonNull(key, "Key cannot be null!");
        return ItemStackBuilderPopulators.setValue(key, random -> List.copyOf(weightedTable.get((RandomGenerator)random)));
    }

    public static <E> BiConsumer<ItemStack.Builder, Random> listValueSuppliers(Key<? extends ListValue<E>> key, WeightedTable<Function<Random, E>> weightedTable) {
        Objects.requireNonNull(key, "Key cannot be null!");
        Objects.requireNonNull(weightedTable, "WeightedTable cannot be null!");
        return (builder, random) -> {
            List suppliers;
            List suppliedElements;
            ItemStack itemStack = builder.build();
            DataTransactionResult result = itemStack.offer(key, suppliedElements = (suppliers = weightedTable.get((RandomGenerator)random)).stream().map(randomEFunction -> randomEFunction.apply(random)).collect(Collectors.toList()));
            if (result.isSuccessful()) {
                builder.from(itemStack);
            }
        };
    }

    public static <E> BiConsumer<ItemStack.Builder, Random> listValueSuppliers(Supplier<? extends Key<? extends ListValue<E>>> key, WeightedTable<Function<Random, E>> weightedTable) {
        Objects.requireNonNull(key, "Key cannot be null!");
        Objects.requireNonNull(weightedTable, "WeightedTable cannot be null!");
        return (builder, random) -> {
            ItemStack itemStack = builder.build();
            List suppliers = weightedTable.get((RandomGenerator)random);
            List suppliedElements = suppliers.stream().map(randomEFunction -> randomEFunction.apply(random)).collect(Collectors.toList());
            DataTransactionResult result = itemStack.offer((Key)key.get(), suppliedElements);
            if (result.isSuccessful()) {
                builder.from(itemStack);
            }
        };
    }

    public static <E> BiConsumer<ItemStack.Builder, Random> setValues(Key<? extends SetValue.Mutable<E>> key, Set<E> elementPool) {
        Objects.requireNonNull(key, "Key cannot be null!");
        Objects.requireNonNull(elementPool, "ElementPool cannot be null!");
        return ItemStackBuilderPopulators.setValues(key, elementPool, VariableAmount.baseWithRandomAddition(1.0, elementPool.size() - 1));
    }

    public static <E> BiConsumer<ItemStack.Builder, Random> setValues(Key<? extends SetValue.Mutable<E>> key, Set<E> elementPool, VariableAmount amount) {
        Objects.requireNonNull(key, "Key cannot be null!");
        Objects.requireNonNull(elementPool, "Element pool cannot be null!");
        Objects.requireNonNull(amount, "VariableAmount cannot be null!");
        if (elementPool.isEmpty()) {
            throw new IllegalArgumentException("Element pool cannot be empty!");
        }
        WeightedTable<E> elementTable = new WeightedTable<E>(amount);
        for (E element : elementPool) {
            elementTable.add(element, 1.0);
        }
        return ItemStackBuilderPopulators.setValues(key, elementTable);
    }

    public static <E> BiConsumer<ItemStack.Builder, Random> setValues(Key<? extends SetValue.Mutable<E>> key, WeightedTable<E> weightedTable) {
        Objects.requireNonNull(weightedTable, "WeightedTable cannot be null!");
        Objects.requireNonNull(key, "Key cannot be null!");
        if (weightedTable.isEmpty()) {
            throw new IllegalArgumentException("WeightedTable cannot be empty!");
        }
        return ItemStackBuilderPopulators.setValue(key, random -> Set.copyOf(weightedTable.get((RandomGenerator)random)));
    }

    private static <E> BiConsumer<ItemStack.Builder, Random> setValue(Key<? extends Value<E>> key, Function<Random, E> element) {
        return (builder, random) -> {
            ItemStack itemStack = builder.build();
            DataTransactionResult result = itemStack.offer(key, element.apply((Random)random));
            if (result.isSuccessful()) {
                builder.from(itemStack);
            }
        };
    }

    public static <E, V extends Value<E>> BiConsumer<ItemStack.Builder, Random> value(V value) {
        return (builder, random) -> {
            ItemStack itemStack = builder.build();
            DataTransactionResult dataTransactionResult = itemStack.offer(value);
            if (dataTransactionResult.isSuccessful()) {
                builder.from(itemStack);
            }
        };
    }

    public static <E, V extends Value<E>> BiConsumer<ItemStack.Builder, Random> values(Iterable<V> values) {
        WeightedTable<Value> tableEntries = new WeightedTable<Value>(1);
        for (Value value : values) {
            tableEntries.add(Objects.requireNonNull(value, "Value cannot be null!"), 1.0);
        }
        return (builder, random) -> {
            Value value = (Value)tableEntries.get((RandomGenerator)random).get(0);
            ItemStack itemStack = builder.build();
            DataTransactionResult result = itemStack.offer(value);
            if (result.isSuccessful()) {
                builder.from(itemStack);
            }
        };
    }

    public static BiConsumer<ItemStack.Builder, Random> values(Collection<Value.Immutable<?>> manipulators, VariableAmount rolls) {
        Objects.requireNonNull(manipulators, "Manipulators cannot be null!");
        Objects.requireNonNull(rolls, "VariableAmount cannot be null!");
        List<Value.Immutable<?>> copied = List.copyOf(manipulators);
        WeightedTable table = new WeightedTable();
        table.setRolls(rolls);
        copied.forEach(manipulator1 -> table.add((Value.Immutable<?>)manipulator1, 1.0));
        return ItemStackBuilderPopulators.values(table);
    }

    public static BiConsumer<ItemStack.Builder, Random> values(WeightedTable<Value.Immutable<?>> weightedTable) {
        Objects.requireNonNull(weightedTable, "WeightedTable cannot be null!");
        return (builder, random) -> weightedTable.get((RandomGenerator)random).forEach(builder::add);
    }

    public static BiConsumer<ItemStack.Builder, Random> enchantment(EnchantmentType enchantmentType) {
        return ItemStackBuilderPopulators.enchantment(VariableAmount.fixed(1.0), enchantmentType);
    }

    public static BiConsumer<ItemStack.Builder, Random> enchantment(VariableAmount level, EnchantmentType enchantmentType) {
        Objects.requireNonNull(level, "VariableAmount cannot be null!");
        Objects.requireNonNull(enchantmentType, "EnchantmentType cannot be null!");
        return ItemStackBuilderPopulators.enchantments(VariableAmount.fixed(1.0), List.of(new Tuple<EnchantmentType, VariableAmount>(enchantmentType, level)));
    }

    public static BiConsumer<ItemStack.Builder, Random> enchantmentsWithVanillaLevelVariance(Collection<EnchantmentType> enchantmentTypes) {
        return ItemStackBuilderPopulators.enchantmentsWithVanillaLevelVariance(VariableAmount.fixed(1.0), List.copyOf(enchantmentTypes));
    }

    public static BiConsumer<ItemStack.Builder, Random> enchantmentsWithVanillaLevelVariance(VariableAmount amount, EnchantmentType enchantmentType, EnchantmentType ... enchantmentTypes) {
        return ItemStackBuilderPopulators.enchantmentsWithVanillaLevelVariance(amount, Stream.concat(Stream.of(enchantmentType), Arrays.stream(enchantmentTypes)).collect(Collectors.toUnmodifiableList()));
    }

    public static BiConsumer<ItemStack.Builder, Random> enchantmentsWithVanillaLevelVariance(VariableAmount amount, Collection<EnchantmentType> itemEnchantmentTypes) {
        Objects.requireNonNull(amount, "Variable amount cannot be null!");
        Objects.requireNonNull(itemEnchantmentTypes, "EnchantmentType collection cannot be null!");
        List<Tuple<EnchantmentType, VariableAmount>> list = itemEnchantmentTypes.stream().map(enchantment -> {
            Objects.requireNonNull(enchantment, "EnchantmentType cannot be null!");
            int minimum = enchantment.minimumLevel();
            int maximum = enchantment.maximumLevel();
            return new Tuple<EnchantmentType, VariableAmount>((EnchantmentType)enchantment, VariableAmount.baseWithRandomAddition((double)minimum, maximum - minimum));
        }).collect(Collectors.toList());
        return ItemStackBuilderPopulators.enchantments(amount, list);
    }

    public static BiConsumer<ItemStack.Builder, Random> enchantments(VariableAmount amount, Collection<Tuple<EnchantmentType, VariableAmount>> enchantments) {
        Objects.requireNonNull(amount, "VariableAmount cannot be null!");
        WeightedTable suppliers = new WeightedTable(amount);
        for (Tuple<EnchantmentType, VariableAmount> enchantment : enchantments) {
            suppliers.add(random -> Enchantment.builder().type((EnchantmentType)enchantment.first()).level(((VariableAmount)enchantment.second()).flooredAmount((RandomGenerator)random)).build(), 1.0);
        }
        return ItemStackBuilderPopulators.listValueSuppliers(Keys.APPLIED_ENCHANTMENTS, suppliers);
    }

    private ItemStackBuilderPopulators() {
        throw new AssertionError((Object)"You should not be attempting to instantiate this class.");
    }
}

