/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.cause.entity.damage.source;

import java.util.Optional;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.cause.entity.damage.DamageScaling;
import org.spongepowered.api.event.cause.entity.damage.DamageScalings;
import org.spongepowered.api.event.cause.entity.damage.DamageType;
import org.spongepowered.api.event.cause.entity.damage.DamageTypes;
import org.spongepowered.api.tag.DamageTypeTags;
import org.spongepowered.api.util.CopyableBuilder;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.math.vector.Vector3d;

public interface DamageSource {
    public static Builder builder() {
        return Sponge.game().builderProvider().provide(Builder.class);
    }

    public DamageType type();

    @Deprecated
    default public boolean isAbsolute() {
        return this.type().is(DamageTypeTags.BYPASSES_EFFECTS) && this.type().is(DamageTypeTags.BYPASSES_ENCHANTMENTS);
    }

    default public boolean isBypassingArmor() {
        return this.type().is(DamageTypeTags.BYPASSES_ARMOR);
    }

    default public boolean isScaledByDifficulty() {
        DamageScaling scaling = this.type().scaling();
        return !DamageScalings.NEVER.get().equals(scaling);
    }

    default public boolean isExplosive() {
        return this.type().is(DamageTypeTags.IS_EXPLOSION);
    }

    default public boolean isMagic() {
        return this.type().equals(DamageTypes.MAGIC.get());
    }

    public boolean doesAffectCreative();

    default public boolean isFire() {
        return this.type().is(DamageTypeTags.IS_FIRE);
    }

    default public double exhaustion() {
        return this.type().exhaustion();
    }

    public Optional<Entity> source();

    public Optional<Entity> indirectSource();

    public Optional<Vector3d> position();

    public Optional<ServerLocation> location();

    public Optional<BlockSnapshot> blockSnapshot();

    public static interface Builder
    extends org.spongepowered.api.util.Builder<DamageSource, Builder>,
    CopyableBuilder<DamageSource, Builder> {
        default public Builder type(Supplier<? extends DamageType> damageType) {
            return this.type(damageType.get());
        }

        public Builder type(DamageType var1);

        public Builder entity(@Nullable Entity var1);

        public Builder indirectEntity(@Nullable Entity var1);

        public Builder block(@Nullable ServerLocation var1);

        public Builder block(@Nullable BlockSnapshot var1);

        public DamageSource build() throws IllegalStateException;
    }

    public static interface Factory {
        public DamageSource drowning();

        public DamageSource dryout();

        public DamageSource falling();

        public DamageSource fireTick();

        public DamageSource generic();

        public DamageSource magic();

        public DamageSource starvation();

        public DamageSource voidSource();

        public DamageSource wither();
    }
}

