/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.cause.entity.damage;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.cause.entity.damage.DamageStepHistory;
import org.spongepowered.api.event.cause.entity.damage.DamageStepType;

public interface DamageStep {
    public DamageStepType type();

    public Cause cause();

    public boolean isSkipped();

    public void setSkipped(boolean var1);

    default public void skip() {
        this.setSkipped(true);
    }

    default public void trySetSkipped(Set<Part> parts, boolean skipped) {
        if (parts.contains((Object)Part.CHILDREN_BEFORE) && this.damageBeforeSelf().isEmpty()) {
            for (DamageStep child : this.childrenBefore()) {
                child.trySetSkipped(Part.ALL, skipped);
            }
        }
        if (parts.contains((Object)Part.SELF) && this.damageAfterSelf().isEmpty()) {
            this.setSkipped(skipped);
        }
        if (parts.contains((Object)Part.CHILDREN_AFTER) && this.damageAfterChildren().isEmpty()) {
            for (DamageStep child : this.childrenAfter()) {
                child.trySetSkipped(Part.ALL, skipped);
            }
        }
    }

    default public void trySkip(Set<Part> parts) {
        this.trySetSkipped(parts, true);
    }

    public OptionalDouble damageBeforeChildren();

    public OptionalDouble damageBeforeSelf();

    public OptionalDouble damageAfterSelf();

    public OptionalDouble damageAfterChildren();

    public DamageStepHistory history();

    public Optional<DamageStep> parent();

    default public DamageStep root() {
        Optional<DamageStep> parent;
        DamageStep step = this;
        while ((parent = step.parent()).isPresent()) {
            step = parent.get();
        }
        return step;
    }

    public List<DamageStep> childrenBefore();

    public List<DamageStep> childrenAfter();

    public static enum Part {
        SELF,
        CHILDREN_BEFORE,
        CHILDREN_AFTER;

        public static final EnumSet<Part> ALL;

        static {
            ALL = EnumSet.allOf(Part.class);
        }
    }
}

