/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event;

import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.Objects;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.plugin.PluginContainer;

public interface EventListenerRegistration<T extends Event> {
    public static <T extends Event> Builder<T> builder(TypeToken<T> eventType) {
        return Sponge.game().factoryProvider().provide(Factory.class).builder(Objects.requireNonNull(eventType, "eventType"));
    }

    public static <T extends Event> Builder<T> builder(Class<T> eventClass) {
        return Sponge.game().factoryProvider().provide(Factory.class).builder(TypeToken.get(eventClass));
    }

    public Type eventType();

    public PluginContainer plugin();

    public Order order();

    public boolean beforeModifications();

    public EventListener<? super T> listener();

    public static interface Factory {
        public <T extends Event> Builder<T> builder(TypeToken<T> var1);
    }

    public static interface Builder<T extends Event>
    extends ResettableBuilder<EventListenerRegistration<T>, Builder<T>> {
        public Builder<T> plugin(PluginContainer var1);

        public Builder<T> order(Order var1);

        public Builder<T> beforeModifications(boolean var1);

        public Builder<T> listener(EventListener<? super T> var1);

        public EventListenerRegistration<T> build();
    }
}

