/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.util.CopyableBuilder;
import org.spongepowered.api.util.annotation.DoNotStore;
import org.spongepowered.eventgen.annotations.NoFactoryMethod;

@DoNotStore
@NoFactoryMethod
public final class Cause
implements Iterable<Object> {
    final Object[] cause;
    private final EventContext context;
    private @Nullable List<Object> immutableCauses;

    public static Builder builder() {
        return new Builder();
    }

    public static Cause of(EventContext ctx, Object cause) {
        Objects.requireNonNull(ctx, "Context");
        Objects.requireNonNull(cause, "Cause cannot be null!");
        return new Cause(ctx, new Object[]{cause});
    }

    public static Cause of(EventContext ctx, Object cause, Object ... causes) {
        Objects.requireNonNull(ctx, "Context");
        Builder builder = Cause.builder();
        builder.append(cause);
        for (Object namedCause : causes) {
            builder.append(namedCause);
        }
        return builder.build(ctx);
    }

    public static Cause of(EventContext ctx, Iterable<Object> iterable) {
        Objects.requireNonNull(ctx, "Context");
        Builder builder = Cause.builder();
        for (Object cause : iterable) {
            builder.append(cause);
        }
        return builder.build(ctx);
    }

    Cause(EventContext ctx, Object[] causes) {
        Objects.requireNonNull(ctx, "Context");
        Object[] objects = new Object[causes.length];
        for (int index = 0; index < causes.length; ++index) {
            objects[index] = Objects.requireNonNull(causes[index], "Null cause element!");
        }
        this.cause = objects;
        this.context = ctx;
    }

    Cause(EventContext ctx, Collection<Object> causes) {
        Objects.requireNonNull(ctx, "Context");
        Object[] objects = new Object[causes.size()];
        int index = 0;
        for (Object cause : causes) {
            objects[index++] = Objects.requireNonNull(cause, "Null cause element!");
        }
        this.cause = objects;
        this.context = ctx;
    }

    public EventContext context() {
        return this.context;
    }

    public Object root() {
        return this.cause[0];
    }

    public <T> Optional<T> first(Class<T> target) {
        for (Object aCause : this.cause) {
            if (!target.isInstance(aCause)) continue;
            return Optional.of(aCause);
        }
        return Optional.empty();
    }

    public <T> Optional<T> last(Class<T> target) {
        for (int i = this.cause.length - 1; i >= 0; --i) {
            if (!target.isInstance(this.cause[i])) continue;
            return Optional.of(this.cause[i]);
        }
        return Optional.empty();
    }

    public Optional<?> before(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("The provided class cannot be null!");
        }
        if (this.cause.length == 1) {
            return Optional.empty();
        }
        for (int i = 0; i < this.cause.length; ++i) {
            if (!clazz.isInstance(this.cause[i]) || i <= 0) continue;
            return Optional.of(this.cause[i - 1]);
        }
        return Optional.empty();
    }

    public Optional<?> after(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("The provided class cannot be null!");
        }
        if (this.cause.length == 1) {
            return Optional.empty();
        }
        for (int i = 0; i < this.cause.length; ++i) {
            if (!clazz.isInstance(this.cause[i]) || i + 1 >= this.cause.length) continue;
            return Optional.of(this.cause[i + 1]);
        }
        return Optional.empty();
    }

    public boolean containsType(Class<?> target) {
        Objects.requireNonNull(target, "The provided class cannot be null!");
        for (Object aCause : this.cause) {
            if (!target.isInstance(aCause)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Object object) {
        for (Object aCause : this.cause) {
            if (!aCause.equals(object)) continue;
            return true;
        }
        return false;
    }

    public <T> List<T> allOf(Class<T> target) {
        return Arrays.stream(this.cause).filter(target::isInstance).map(entry -> entry).collect(Collectors.toUnmodifiableList());
    }

    public List<Object> noneOf(Class<?> ignoredClass) {
        return Arrays.stream(this.cause).filter(entry -> !ignoredClass.isInstance(entry)).collect(Collectors.toUnmodifiableList());
    }

    public List<Object> all() {
        if (this.immutableCauses == null) {
            this.immutableCauses = List.of(this.cause);
        }
        return this.immutableCauses;
    }

    public Cause with(Object additional) {
        Objects.requireNonNull(additional, "No null arguments allowed!");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(additional);
        return this.with(list);
    }

    public Cause with(Object additional, Object ... additionals) {
        Objects.requireNonNull(additional, "No null arguments allowed!");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(additional);
        for (Object object : additionals) {
            Objects.requireNonNull(object, "Cannot add null objects!");
            list.add(object);
        }
        return this.with(list);
    }

    public Cause with(Iterable<Object> iterable) {
        Builder builder = new Builder().from(this);
        for (Object o : iterable) {
            Objects.requireNonNull(o, "Cannot add null causes");
            builder.append(o);
        }
        return builder.build(this.context);
    }

    public Cause with(Cause cause) {
        Builder builder = Cause.builder().from(this);
        for (int i = 0; i < cause.cause.length; ++i) {
            builder.append(cause.cause[i]);
        }
        return builder.build(this.context);
    }

    @Override
    public Iterator<Object> iterator() {
        return new Itr();
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof Cause) {
            Cause cause = (Cause)object;
            return Arrays.equals(this.cause, cause.cause);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.cause);
    }

    public String toString() {
        String causeString = "Cause[Context=" + this.context.toString() + ", Stack={";
        StringJoiner joiner = new StringJoiner(", ");
        for (int i = 0; i < this.cause.length; ++i) {
            joiner.add(this.cause[i].toString());
        }
        return causeString + joiner.toString() + "}]";
    }

    public static final class Builder
    implements org.spongepowered.api.util.Builder<Cause, Builder>,
    CopyableBuilder<Cause, Builder> {
        final List<Object> causes = new ArrayList<Object>();

        Builder() {
        }

        public Builder append(Object cause) {
            Objects.requireNonNull(cause, "Cause cannot be null!");
            if (!this.causes.isEmpty() && this.causes.get(this.causes.size() - 1) == cause) {
                return this;
            }
            this.causes.add(cause);
            return this;
        }

        public Builder insert(int position, Object cause) {
            Objects.requireNonNull(cause, "Cause cannot be null!");
            this.causes.add(position, cause);
            return this;
        }

        public Builder appendAll(Collection<Object> causes) {
            Objects.requireNonNull(causes, "Causes cannot be null!");
            causes.forEach(this::append);
            return this;
        }

        @Override
        public Builder from(Cause value) {
            for (int i = 0; i < value.cause.length; ++i) {
                this.causes.add(value.cause[i]);
            }
            return this;
        }

        @Override
        public Builder reset() {
            this.causes.clear();
            return this;
        }

        public Cause build() {
            if (this.causes.isEmpty()) {
                throw new IllegalStateException("Cannot create an empty Cause!");
            }
            return new Cause(EventContext.empty(), this.causes);
        }

        public Cause build(EventContext ctx) {
            if (this.causes.isEmpty()) {
                throw new IllegalStateException("Cannot create an empty Cause!");
            }
            return new Cause(ctx, this.causes);
        }
    }

    private class Itr
    implements Iterator<Object> {
        private int index = 0;

        Itr() {
        }

        @Override
        public Object next() {
            if (this.index >= Cause.this.cause.length) {
                throw new NoSuchElementException();
            }
            return Cause.this.cause[this.index++];
        }

        @Override
        public boolean hasNext() {
            return this.index != Cause.this.cause.length;
        }
    }
}

