/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.entity;

import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.math.vector.Vector3d;

public final class EntityPredicates {
    public static final Predicate<? super Entity> NO_SPECTATOR = entity -> entity.get(Keys.GAME_MODE).map(gamemode -> gamemode == GameModes.SPECTATOR.get()).orElse(false);
    public static final Predicate<? super Entity> STILL_ALIVE = entity -> !entity.isRemoved() && entity.get(Keys.HEALTH).map(hp -> hp > 0.0).orElse(false) != false;

    public static Predicate<? super @Nullable Entity> withinDistance(double x, double y, double z, double distance) {
        double distSqrd = distance * distance;
        return entity -> {
            double zDist;
            double yDist;
            if (entity == null) {
                return false;
            }
            Vector3d pos = entity.location().position();
            double xDist = pos.x() - x;
            return xDist * xDist + (yDist = pos.y() - y) * yDist + (zDist = pos.z() - z) * zDist <= distSqrd;
        };
    }
}

