/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.effect;

import java.util.Objects;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.sound.Sound;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.sound.music.MusicDisc;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public interface Viewer
extends Audience {
    public void sendWorldType(WorldType var1);

    default public void spawnParticles(ParticleEffect particleEffect, Vector3d position) {
        Objects.requireNonNull(position, "position");
        this.spawnParticles(particleEffect, position.x(), position.y(), position.z());
    }

    public void spawnParticles(ParticleEffect var1, double var2, double var4, double var6);

    default public void playSound(@NonNull Sound sound, Vector3d position) {
        Objects.requireNonNull(position, "position");
        this.playSound(sound, position.x(), position.y(), position.z());
    }

    default public void playMusicDisc(Vector3i position, MusicDisc musicDisc) {
        Objects.requireNonNull(position, "position");
        this.playMusicDisc(position.x(), position.y(), position.z(), musicDisc);
    }

    public void playMusicDisc(int var1, int var2, int var3, MusicDisc var4);

    default public void stopMusicDisc(Vector3i position) {
        Objects.requireNonNull(position, "position");
        this.stopMusicDisc(position.x(), position.y(), position.z());
    }

    public void stopMusicDisc(int var1, int var2, int var3);

    default public void sendBlockChange(Vector3i position, BlockState state) {
        Objects.requireNonNull(position, "position");
        this.sendBlockChange(position.x(), position.y(), position.z(), state);
    }

    public void sendBlockChange(int var1, int var2, int var3, BlockState var4);

    default public void resetBlockChange(Vector3i position) {
        Objects.requireNonNull(position, "position");
        this.resetBlockChange(position.x(), position.y(), position.z());
    }

    public void resetBlockChange(int var1, int var2, int var3);

    default public void sendBlockProgress(Vector3i position, double progress) {
        Objects.requireNonNull(position, "position");
        this.sendBlockProgress(position.x(), position.y(), position.z(), progress);
    }

    public void sendBlockProgress(int var1, int var2, int var3, double var4);

    default public void resetBlockProgress(Vector3i position) {
        Objects.requireNonNull(position, "position");
        this.resetBlockProgress(position.x(), position.y(), position.z());
    }

    public void resetBlockProgress(int var1, int var2, int var3);
}

