/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.persistence;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryType;

public interface DataView {
    public DataContainer container();

    public DataQuery currentPath();

    public String name();

    public Optional<DataView> parent();

    public Set<DataQuery> keys(boolean var1);

    public Map<DataQuery, Object> values(boolean var1);

    public boolean contains(DataQuery var1);

    public boolean contains(DataQuery var1, DataQuery ... var2);

    public Optional<Object> get(DataQuery var1);

    public DataView set(DataQuery var1, Object var2);

    public DataView remove(DataQuery var1);

    public DataView createView(DataQuery var1);

    public DataView createView(DataQuery var1, Map<?, ?> var2);

    public Optional<DataView> getView(DataQuery var1);

    public Optional<? extends Map<?, ?>> getMap(DataQuery var1);

    public Optional<Boolean> getBoolean(DataQuery var1);

    public Optional<Short> getShort(DataQuery var1);

    public Optional<Byte> getByte(DataQuery var1);

    public Optional<Integer> getInt(DataQuery var1);

    public Optional<Long> getLong(DataQuery var1);

    public Optional<Float> getFloat(DataQuery var1);

    public Optional<Double> getDouble(DataQuery var1);

    public Optional<String> getString(DataQuery var1);

    default public Optional<ResourceKey> getResourceKey(DataQuery path) {
        Objects.requireNonNull(path, "path");
        Optional<String> value = this.getString(path);
        if (!value.isPresent()) {
            return Optional.empty();
        }
        try {
            return Optional.of(ResourceKey.resolve(value.get()));
        }
        catch (Exception ignore) {
            return Optional.empty();
        }
    }

    default public Optional<List<ResourceKey>> getResourceKeyList(DataQuery path) {
        Objects.requireNonNull(path, "path");
        Optional<List<String>> strings = this.getStringList(path);
        if (!strings.isPresent()) {
            return Optional.empty();
        }
        ArrayList<ResourceKey> keys = new ArrayList<ResourceKey>();
        for (String s : strings.get()) {
            try {
                keys.add(ResourceKey.resolve(s));
            }
            catch (Exception exception) {}
        }
        if (keys.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(keys);
    }

    public Optional<List<?>> getList(DataQuery var1);

    public Optional<List<String>> getStringList(DataQuery var1);

    public Optional<List<Character>> getCharacterList(DataQuery var1);

    public Optional<List<Boolean>> getBooleanList(DataQuery var1);

    public Optional<List<Byte>> getByteList(DataQuery var1);

    public Optional<List<Short>> getShortList(DataQuery var1);

    public Optional<List<Integer>> getIntegerList(DataQuery var1);

    public Optional<List<Long>> getLongList(DataQuery var1);

    public Optional<List<Float>> getFloatList(DataQuery var1);

    public Optional<List<Double>> getDoubleList(DataQuery var1);

    public Optional<List<Map<?, ?>>> getMapList(DataQuery var1);

    public Optional<List<DataView>> getViewList(DataQuery var1);

    public <T extends DataSerializable> Optional<T> getSerializable(DataQuery var1, Class<T> var2);

    public <T extends DataSerializable> Optional<List<T>> getSerializableList(DataQuery var1, Class<T> var2);

    public <T> Optional<T> getObject(DataQuery var1, Class<T> var2);

    public <T> Optional<List<T>> getObjectList(DataQuery var1, Class<T> var2);

    default public <T> Optional<T> getRegistryValue(DataQuery path, RegistryType<T> registryType) {
        return this.getRegistryValue(Objects.requireNonNull(path, "path"), Objects.requireNonNull(registryType, "registryType"), Sponge.game());
    }

    default public <T> Optional<List<T>> getRegistryValueList(DataQuery path, RegistryType<T> registryType) {
        return this.getRegistryValueList(Objects.requireNonNull(path, "path"), Objects.requireNonNull(registryType, "registryType"), Sponge.game());
    }

    public <T> Optional<T> getRegistryValue(DataQuery var1, RegistryType<T> var2, RegistryHolder var3);

    public <T> Optional<List<T>> getRegistryValueList(DataQuery var1, RegistryType<T> var2, RegistryHolder var3);

    public <E, V extends Value<E>> Optional<Key<V>> getDataKey(DataQuery var1);

    public Optional<List<Key<? extends Value<?>>>> getDataKeyList(DataQuery var1);

    public DataContainer copy();

    public DataContainer copy(SafetyMode var1);

    public boolean isEmpty();

    public SafetyMode safetyMode();

    public static enum SafetyMode {
        ALL_DATA_CLONED,
        CLONED_ON_SET,
        NO_DATA_CLONED;

    }
}

