/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data;

import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.ResourceKeyed;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.value.ListValue;
import org.spongepowered.api.data.value.MapValue;
import org.spongepowered.api.data.value.SetValue;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.data.value.WeightedCollectionValue;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.event.data.ChangeDataHolderEvent;
import org.spongepowered.api.util.ResourceKeyedBuilder;
import org.spongepowered.api.util.annotation.CatalogedBy;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.plugin.PluginContainer;

@CatalogedBy(value={Keys.class})
public interface Key<V extends Value<?>>
extends ResourceKeyed {
    public static Builder<?, ?> builder() {
        return Sponge.game().builderProvider().provide(Builder.class);
    }

    public static <V> Key<Value<V>> from(PluginContainer plugin, String value, Class<V> type) {
        return Key.from(ResourceKey.of(Objects.requireNonNull(plugin, "plugin"), value), type);
    }

    public static <E> Key<Value<E>> from(ResourceKey resourceKey, Class<E> type) {
        return ((Builder)Key.builder().key(Objects.requireNonNull(resourceKey, "resourceKey"))).elementType(Objects.requireNonNull(type, "type")).build();
    }

    public static <V> Key<ListValue<V>> fromList(PluginContainer plugin, String value, Class<V> type) {
        return Key.fromList(ResourceKey.of(Objects.requireNonNull(plugin, "plugin"), value), type);
    }

    public static <E> Key<ListValue<E>> fromList(ResourceKey resourceKey, Class<E> type) {
        return ((Builder)Key.builder().key(Objects.requireNonNull(resourceKey, "resourceKey"))).listElementType(Objects.requireNonNull(type, "type")).build();
    }

    public static <V> Key<SetValue<V>> fromSet(PluginContainer plugin, String value, Class<V> type) {
        return Key.fromSet(ResourceKey.of(Objects.requireNonNull(plugin, "plugin"), value), type);
    }

    public static <E> Key<SetValue<E>> fromSet(ResourceKey resourceKey, Class<E> type) {
        return ((Builder)Key.builder().key(Objects.requireNonNull(resourceKey, "resourceKey"))).setElementType(Objects.requireNonNull(type, "type")).build();
    }

    public static <K, V> Key<MapValue<K, V>> fromMap(PluginContainer plugin, String value, Class<K> keyType, Class<V> valueType) {
        return Key.fromMap(ResourceKey.of(Objects.requireNonNull(plugin, "plugin"), value), keyType, valueType);
    }

    public static <K, V> Key<MapValue<K, V>> fromMap(ResourceKey resourceKey, Class<K> keyType, Class<V> valueType) {
        return ((Builder)Key.builder().key(Objects.requireNonNull(resourceKey, "resourceKey"))).mapElementType(Objects.requireNonNull(keyType, "keyType"), Objects.requireNonNull(valueType, "valueType")).build();
    }

    public Type valueType();

    public Type elementType();

    public Comparator<?> elementComparator();

    public BiPredicate<?, ?> elementIncludesTester();

    public <E extends DataHolder> void registerEvent(PluginContainer var1, Class<E> var2, EventListener<ChangeDataHolderEvent.ValueChange> var3);

    public static interface Builder<E, V extends Value<E>>
    extends ResourceKeyedBuilder<Key<V>, Builder<E, V>> {
        public <T, B extends Value<T>> Builder<T, B> type(TypeToken<B> var1);

        public <T> Builder<T, Value<T>> elementType(Class<T> var1);

        public <T> Builder<T, Value<T>> elementType(TypeToken<T> var1);

        public <T> Builder<List<T>, ListValue<T>> listElementType(Class<T> var1);

        public <T> Builder<List<T>, ListValue<T>> listElementType(TypeToken<T> var1);

        public <T> Builder<Set<T>, SetValue<T>> setElementType(Class<T> var1);

        public <T> Builder<Set<T>, SetValue<T>> setElementType(TypeToken<T> var1);

        public <K, V> Builder<Map<K, V>, MapValue<K, V>> mapElementType(Class<K> var1, Class<V> var2);

        public <K, V> Builder<Map<K, V>, MapValue<K, V>> mapElementType(TypeToken<K> var1, TypeToken<V> var2);

        public <T> Builder<WeightedTable<T>, WeightedCollectionValue<T>> weightedCollectionElementType(Class<T> var1);

        public <T> Builder<WeightedTable<T>, WeightedCollectionValue<T>> weightedCollectionElementType(TypeToken<T> var1);

        public Builder<E, V> comparator(Comparator<? super E> var1);

        public Builder<E, V> includesTester(BiPredicate<? super E, ? super E> var1);

        public Key<V> build();
    }
}

