/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.block.transaction;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.transaction.Operation;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;

public final class BlockTransaction
extends Transaction<BlockSnapshot> {
    private final Operation operation;
    private @Nullable WeakReference<BlockSnapshot> custom;
    private @Nullable BlockChangeFlag customFlag;

    public BlockTransaction(BlockSnapshot original, BlockSnapshot defaultReplacement, Operation operation) {
        super(original, defaultReplacement);
        this.operation = operation;
    }

    public BlockTransaction(BlockSnapshot original, BlockSnapshot defaultReplacement, @Nullable List<? extends BlockSnapshot> intermediary, Operation operation) {
        super(original, defaultReplacement, intermediary);
        this.operation = operation;
    }

    public Operation operation() {
        return this.operation;
    }

    public void setCustom(@Nullable BlockSnapshot custom, BlockChangeFlag flag) {
        this.setCustom(custom);
        if (custom != null) {
            this.custom = new WeakReference<BlockSnapshot>(custom);
            this.customFlag = flag;
        } else {
            this.custom = null;
            this.customFlag = null;
        }
    }

    public BlockChangeFlag customFlag() {
        if (this.custom().isEmpty() || this.custom == null || this.custom.get() != this.custom().get()) {
            return BlockChangeFlags.DEFAULT_PLACEMENT;
        }
        return this.customFlag;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.operation);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlockTransaction other = (BlockTransaction)obj;
        return Objects.equals(this.original(), other.original()) && Objects.equals(this.defaultReplacement(), other.defaultReplacement()) && this.isValid() == other.isValid() && Objects.equals(this.custom(), other.custom()) && Objects.equals(this.operation, other.operation);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", BlockTransaction.class.getSimpleName() + "[", "]").add("operation=" + String.valueOf(this.operation)).add("original=" + String.valueOf(this.original())).add("default=" + String.valueOf(this.defaultReplacement())).add("custom=" + String.valueOf(this.custom())).add("valid=" + this.isValid()).toString();
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Queries.BLOCK_OPERATION, this.operation);
    }
}

