/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.adventure;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import org.spongepowered.api.Sponge;

public final class Audiences {
    public static Audience server() {
        return Sponge.game().server();
    }

    public static Audience onlinePlayers() {
        return Audiences.factory().onlinePlayers();
    }

    public static Audience withPermission(String permission) {
        Objects.requireNonNull(permission);
        return Audiences.factory().withPermission(permission);
    }

    public static Optional<Audience> filtered(Audience audience, Predicate<Audience> predicate) {
        if (!(audience instanceof ForwardingAudience)) {
            if (predicate.test(audience)) {
                return Optional.of(audience);
            }
            return Optional.empty();
        }
        ArrayList list = new ArrayList();
        for (Audience subAudience : ((ForwardingAudience)audience).audiences()) {
            Audiences.filtered(subAudience, predicate).ifPresent(list::add);
        }
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(() -> list);
    }

    public static Audience system() {
        return Sponge.game().systemSubject();
    }

    private static Factory factory() {
        return Sponge.game().factoryProvider().provide(Factory.class);
    }

    public static interface Factory {
        public Audience onlinePlayers();

        public Audience withPermission(String var1);
    }
}

