/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.builtin.jvm.locator;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.jar.Manifest;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.plugin.PluginResource;
import org.spongepowered.plugin.builtin.jvm.locator.ResourceType;

public class JVMPluginResource
implements PluginResource {
    private final String locator;
    private final Path path;
    private final ResourceType type;
    private final Manifest manifest;
    private FileSystem fileSystem;

    public JVMPluginResource(String locator, ResourceType type, Path path, @Nullable Manifest manifest) {
        this.locator = Objects.requireNonNull(locator, "locator");
        this.path = Objects.requireNonNull(path, "path");
        this.type = Objects.requireNonNull(type, "type");
        this.manifest = manifest;
    }

    @Override
    public final String locator() {
        return this.locator;
    }

    @Override
    public final Path path() {
        return this.path;
    }

    @Override
    public Optional<String> property(String key) {
        return Optional.ofNullable(this.manifest.getMainAttributes().getValue(Objects.requireNonNull(key, "key")));
    }

    public final ResourceType type() {
        return this.type;
    }

    public final Optional<Manifest> manifest() {
        return Optional.ofNullable(this.manifest);
    }

    @Override
    public final Optional<URI> locateResource(URI relative) {
        switch (this.type) {
            case DIRECTORY: {
                ClassLoader classLoader = this.getClass().getClassLoader();
                URL resolved = classLoader.getResource(relative.getPath());
                try {
                    if (resolved == null) {
                        return Optional.empty();
                    }
                    return Optional.of(resolved.toURI());
                }
                catch (URISyntaxException ignored) {
                    return Optional.empty();
                }
            }
            case JAR: {
                Path file = this.fileSystem().getPath(relative.getPath(), new String[0]);
                return Files.exists(file, new LinkOption[0]) ? Optional.of(file.toUri()) : Optional.empty();
            }
        }
        throw new IllegalStateException("Unknown resource type " + (Object)((Object)this.type));
    }

    public FileSystem fileSystem() {
        if (this.fileSystem == null) {
            try {
                this.fileSystem = FileSystems.newFileSystem(this.path, this.getClass().getClassLoader());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.fileSystem;
    }

    protected StringJoiner toStringJoiner() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("locator='" + this.locator + "'").add("type=" + (Object)((Object)this.type)).add("path=" + this.path).add("fileSystem=" + this.fileSystem);
    }

    public final String toString() {
        return this.toStringJoiner().toString();
    }
}

