/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.builtin.jvm.locator;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.spongepowered.plugin.Environment;
import org.spongepowered.plugin.blackboard.Keys;
import org.spongepowered.plugin.builtin.jvm.JVMKeys;
import org.spongepowered.plugin.builtin.jvm.locator.JVMPluginResource;
import org.spongepowered.plugin.builtin.jvm.locator.JVMPluginResourceLocatorService;
import org.spongepowered.plugin.builtin.jvm.locator.ResourceType;

public final class DirectoryPluginResourceLocatorService
extends JVMPluginResourceLocatorService {
    private static final String NAME = "java_directory";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public Set<JVMPluginResource> locatePluginResources(Environment environment) {
        environment.logger().info("Locating '{}' resources...", (Object)this.name());
        HashSet<JVMPluginResource> pluginFiles = new HashSet<JVMPluginResource>();
        String metadataPath = environment.blackboard().get(JVMKeys.METADATA_FILE_PATH);
        for (Path pluginsDir : environment.blackboard().find(Keys.PLUGIN_DIRECTORIES).orElseGet(Collections::emptyList)) {
            if (Files.notExists(pluginsDir, new LinkOption[0])) {
                environment.logger().debug("Plugin directory '{}' does not exist for locator '{}'. Skipping...", (Object)pluginsDir, (Object)this.name());
                continue;
            }
            try {
                for (Path path : Files.walk(pluginsDir, new FileVisitOption[0]).collect(Collectors.toList())) {
                    if (!Files.isRegularFile(path, new LinkOption[0]) || !path.getFileName().toString().endsWith(".jar")) continue;
                    try (JarFile jf = new JarFile(path.toFile());){
                        Manifest manifest = jf.getManifest();
                        if (!this.isValidManifest(environment, manifest)) {
                            environment.logger().error("Manifest specified in '{}' is not valid for locator '{}'. Skipping...", (Object)path, (Object)this.name());
                            continue;
                        }
                        JarEntry pluginMetadataJarEntry = jf.getJarEntry(metadataPath);
                        if (pluginMetadataJarEntry == null) {
                            environment.logger().debug("'{}' does not contain any plugin metadata so it is not a plugin. Skipping...", (Object)path);
                            continue;
                        }
                        pluginFiles.add(new JVMPluginResource(this.name(), ResourceType.JAR, path, manifest));
                    }
                    catch (IOException e) {
                        environment.logger().error("Error reading '{}' as a Jar file when traversing directory resources for plugin discovery! Skipping...", (Object)path, (Object)e);
                    }
                }
            }
            catch (IOException ex) {
                environment.logger().error("Error walking plugins directory {}", (Object)pluginsDir, (Object)ex);
            }
        }
        environment.logger().info("Located [{}] resource(s) for '{}'...", (Object)pluginFiles.size(), (Object)this.name());
        return pluginFiles;
    }
}

