/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.builtin.jvm.locator;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.spongepowered.plugin.Environment;
import org.spongepowered.plugin.builtin.jvm.JVMKeys;
import org.spongepowered.plugin.builtin.jvm.locator.JVMPluginResource;
import org.spongepowered.plugin.builtin.jvm.locator.JVMPluginResourceLocatorService;
import org.spongepowered.plugin.builtin.jvm.locator.ResourceType;

public final class ClasspathPluginResourceLocatorService
extends JVMPluginResourceLocatorService {
    private static final String NAME = "java_classpath";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public Set<JVMPluginResource> locatePluginResources(Environment environment) {
        Enumeration<URL> resources;
        environment.logger().info("Locating '{}' resources...", (Object)this.name());
        String metadataPath = environment.blackboard().get(JVMKeys.METADATA_FILE_PATH);
        HashSet<JVMPluginResource> pluginFiles = new HashSet<JVMPluginResource>();
        try {
            resources = ClassLoader.getSystemClassLoader().getResources(metadataPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to enumerate classloader resources!");
        }
        while (resources.hasMoreElements()) {
            Path path;
            URI uri;
            URL url = resources.nextElement();
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException e) {
                environment.logger().error("Malformed URL '{}'. Skipping...", (Object)url, (Object)e);
                continue;
            }
            if (uri.getRawSchemeSpecificPart().contains("!")) {
                URI parentUri;
                try {
                    parentUri = new URI(uri.getRawSchemeSpecificPart().split("!")[0]);
                }
                catch (URISyntaxException e) {
                    environment.logger().error("Malformed URI for Jar '{}. Skipping...", (Object)url, (Object)e);
                    continue;
                }
                path = Paths.get(parentUri);
                try (JarFile jf = new JarFile(path.toFile());){
                    pluginFiles.add(new JVMPluginResource(this.name(), ResourceType.JAR, path, jf.getManifest()));
                }
                catch (IOException e) {
                    environment.logger().error("Error reading '{}' as a Jar file. Skipping...", (Object)url, (Object)e);
                }
                continue;
            }
            try {
                path = Paths.get(new URI("file://" + uri.getRawSchemeSpecificPart().substring(0, uri.getRawSchemeSpecificPart().length() - metadataPath.length())));
            }
            catch (URISyntaxException e) {
                environment.logger().error("Error creating root URI for '{}'. Skipping...", (Object)url, (Object)e);
                continue;
            }
            Path manifestPath = path.resolve("META-INF/MANIFEST.MF");
            Manifest manifest = null;
            try (InputStream stream2 = Files.newInputStream(manifestPath, new OpenOption[0]);){
                manifest = new Manifest(stream2);
            }
            catch (NoSuchFileException stream2) {
            }
            catch (IOException e) {
                environment.logger().error("Malformed URL '{}' in locator '{}'. Skipping...", (Object)url, (Object)e);
                continue;
            }
            if (manifest != null && !this.isValidManifest(environment, manifest)) {
                environment.logger().error("Manifest specified in '{}' is not valid. Skipping...", (Object)url);
                continue;
            }
            pluginFiles.add(new JVMPluginResource(this.name(), ResourceType.DIRECTORY, path, manifest));
        }
        environment.logger().info("Located [{}] resource(s) for '{}'...", (Object)pluginFiles.size(), (Object)this.name());
        return pluginFiles;
    }
}

