/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.builtin;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.spongepowered.plugin.blackboard.Blackboard;
import org.spongepowered.plugin.blackboard.Key;

public final class StandardBlackboard
implements Blackboard {
    private final Map<Key<Object>, Object> values = new HashMap<Key<Object>, Object>();

    @Override
    public <V> V getOrCreate(Key<V> key, Supplier<? super V> defaultValue) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(defaultValue, "defaultValue");
        return key.clazz().cast(this.values.computeIfAbsent(key, k -> defaultValue.get()));
    }

    @Override
    public <V> V get(Key<V> key) {
        Object rawValue = this.values.get(Objects.requireNonNull(key, "key"));
        if (rawValue == null) {
            throw new IllegalArgumentException(String.format("Key '%s' has no value!", key.name()));
        }
        return key.clazz().cast(rawValue);
    }

    @Override
    public <V> Optional<V> find(Key<V> key) {
        Object value = this.values.get(Objects.requireNonNull(key, "key"));
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(key.clazz().cast(value));
    }
}

