/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.blackboard;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class Key<V>
implements Comparable<Key<V>> {
    private final String name;
    private final Class<V> clazz;

    private Key(String name, Class<V> clazz) {
        this.name = Objects.requireNonNull(name, "name");
        this.clazz = clazz;
    }

    public static <V> Key<V> of(String name, Class<? super V> clazz) {
        return new Key<V>(name, clazz);
    }

    public String name() {
        return this.name;
    }

    public Class<V> clazz() {
        return this.clazz;
    }

    @Override
    public int compareTo(@NonNull Key<V> that) {
        if (this == that) {
            return 0;
        }
        return this.name.compareTo(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Key)) {
            return false;
        }
        return this.name.equals(((Key)obj).name);
    }
}

