/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.metadata.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class GsonUtils {
    public static <T, V extends Collection<T>> V read(JsonArray in, TypeAdapter<T> adapter, Supplier<V> collector) {
        Collection parsed = (Collection)collector.get();
        for (JsonElement element : in) {
            parsed.add(adapter.fromJsonTree(element));
        }
        return (V)parsed;
    }

    public static Map<String, Object> read(JsonObject in, Function<JsonElement, Object> valFunc, Supplier<Map<String, Object>> collector) {
        Map<String, Object> parsed = collector.get();
        for (Map.Entry entry : in.entrySet()) {
            parsed.put((String)entry.getKey(), valFunc.apply((JsonElement)entry.getValue()));
        }
        return parsed;
    }

    public static <T> JsonArray write(TypeAdapter<T> adapter, Collection<T> value) {
        JsonArray array = new JsonArray();
        for (T val : value) {
            array.add(adapter.toJsonTree(val));
        }
        return array;
    }

    public static JsonObject write(Function<Object, JsonElement> valFunc, Map<String, Object> value) {
        JsonObject obj = new JsonObject();
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            obj.add(entry.getKey(), valFunc.apply(entry.getValue()));
        }
        return obj;
    }

    public static <T> void writeIfPresent(JsonWriter out, String name, Optional<T> value) throws IOException {
        if (value.isPresent()) {
            out.name(name).value(value.get().toString());
        }
    }

    public static <T> void writeIfPresent(JsonObject out, String key, Optional<T> value) {
        @Nullable Object val = value.orElse(null);
        if (val == null) {
            return;
        }
        if (val instanceof JsonElement) {
            out.add(key, (JsonElement)val);
        } else if (val instanceof String) {
            out.addProperty(key, (String)val);
        } else if (val instanceof Number) {
            out.addProperty(key, (Number)val);
        } else if (val instanceof Boolean) {
            out.addProperty(key, (Boolean)val);
        } else if (val instanceof Character) {
            out.addProperty(key, (Character)val);
        }
    }

    public static <T extends JsonElement> void consumeIfPresent(JsonObject obj, String key, Consumer<T> consumer) {
        if (obj.has(key)) {
            consumer.accept(obj.get(key));
        }
    }

    public static <T> void applyIfValid(JsonObject obj, T value, Predicate<T> validator, BiConsumer<JsonObject, T> consumer) {
        if (validator.test(value)) {
            consumer.accept(obj, (JsonObject)value);
        }
    }

    public static <T> Optional<T> get(JsonObject obj, String key, Function<JsonElement, T> valFunc) {
        if (!obj.has(key)) {
            return Optional.empty();
        }
        return Optional.of(valFunc.apply(obj.get(key)));
    }
}

