/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.metadata.builtin.model;

import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.plugin.metadata.model.PluginLinks;
import org.spongepowered.plugin.metadata.util.GsonUtils;

public final class StandardPluginLinks
implements PluginLinks {
    private static final StandardPluginLinks NONE = new StandardPluginLinks();
    private final @Nullable URL homepage;
    private final @Nullable URL source;
    private final @Nullable URL issues;

    private StandardPluginLinks(Builder builder) {
        this.homepage = builder.homepage;
        this.source = builder.source;
        this.issues = builder.issues;
    }

    private StandardPluginLinks() {
        this.homepage = null;
        this.source = null;
        this.issues = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static StandardPluginLinks none() {
        return NONE;
    }

    @Override
    public Optional<URL> homepage() {
        return Optional.ofNullable(this.homepage);
    }

    @Override
    public Optional<URL> source() {
        return Optional.ofNullable(this.source);
    }

    @Override
    public Optional<URL> issues() {
        return Optional.ofNullable(this.issues);
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.homepage = this.homepage;
        builder.source = this.source;
        builder.issues = this.issues;
        return builder;
    }

    public String toString() {
        return new StringJoiner(", ", StandardPluginLinks.class.getSimpleName() + "[", "]").add("homepage=" + this.homepage).add("source=" + this.source).add("issues=" + this.issues).toString();
    }

    public static final class Builder {
        @Nullable URL homepage;
        @Nullable URL source;
        @Nullable URL issues;

        private Builder() {
        }

        public Builder homepage(@Nullable URL homepage) {
            this.homepage = homepage;
            return this;
        }

        public Builder source(@Nullable URL source) {
            this.source = source;
            return this;
        }

        public Builder issues(@Nullable URL issues) {
            this.issues = issues;
            return this;
        }

        public StandardPluginLinks build() {
            return new StandardPluginLinks(this);
        }
    }

    public static final class Serializer
    extends TypeAdapter<StandardPluginLinks> {
        public void write(JsonWriter out, StandardPluginLinks value) throws IOException {
            Objects.requireNonNull(out, "out");
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            GsonUtils.writeIfPresent(out, "homepage", value.homepage());
            GsonUtils.writeIfPresent(out, "source", value.source());
            GsonUtils.writeIfPresent(out, "issues", value.issues());
            out.endObject();
        }

        public StandardPluginLinks read(JsonReader out) throws IOException {
            throw new UnsupportedOperationException("This adapter is for writing only");
        }
    }

    public static final class Deserializer
    extends TypeAdapter<Builder> {
        public void write(JsonWriter in, Builder builder) throws IOException {
            throw new UnsupportedOperationException("This adapter is for reading only");
        }

        public Builder read(JsonReader in) throws IOException {
            Objects.requireNonNull(in, "in");
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            HashSet<String> processedKeys = new HashSet<String>();
            Builder builder = StandardPluginLinks.builder();
            while (in.hasNext()) {
                String key = in.nextName();
                if (!processedKeys.add(key)) {
                    throw new JsonParseException(String.format("Duplicate links key '%s' in %s", key, in));
                }
                switch (key) {
                    case "homepage": {
                        builder.homepage(new URL(in.nextString()));
                        break;
                    }
                    case "source": {
                        builder.source(new URL(in.nextString()));
                        break;
                    }
                    case "issues": {
                        builder.issues(new URL(in.nextString()));
                    }
                }
            }
            in.endObject();
            return builder;
        }
    }
}

