/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.BasicConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.ConfigurationVisitor;
import org.spongepowered.configurate.jackson.ConfiguratePrettyPrinter;
import org.spongepowered.configurate.jackson.FieldValueSeparatorStyle;
import org.spongepowered.configurate.jackson.JacksonVisitor;
import org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import org.spongepowered.configurate.loader.CommentHandler;
import org.spongepowered.configurate.loader.CommentHandlers;
import org.spongepowered.configurate.loader.ParsingException;
import org.spongepowered.configurate.util.UnmodifiableCollections;

public final class JacksonConfigurationLoader
extends AbstractConfigurationLoader<BasicConfigurationNode> {
    private static final Set<Class<?>> NATIVE_TYPES = UnmodifiableCollections.toSet((Object[])new Class[]{Map.class, List.class, Double.class, Float.class, Long.class, Integer.class, Boolean.class, String.class, byte[].class});
    private final JsonFactory factory;
    private final int indent;
    private final FieldValueSeparatorStyle fieldValueSeparatorStyle;
    private static final int MAX_CTX_LENGTH = 80;

    public static Builder builder() {
        return new Builder();
    }

    private JacksonConfigurationLoader(Builder builder) {
        super((AbstractConfigurationLoader.Builder)builder, new CommentHandler[]{CommentHandlers.DOUBLE_SLASH, CommentHandlers.SLASH_BLOCK, CommentHandlers.HASH});
        this.factory = builder.factoryBuilder().build();
        this.factory.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        this.indent = builder.indent();
        this.fieldValueSeparatorStyle = builder.fieldValueSeparatorStyle();
    }

    protected void loadInternal(BasicConfigurationNode node, BufferedReader reader) throws ParsingException {
        try (JsonParser parser = this.factory.createParser((Reader)reader);){
            parser.nextToken();
            JacksonConfigurationLoader.parseValue(parser, (ConfigurationNode)node);
        }
        catch (StreamReadException ex) {
            throw JacksonConfigurationLoader.newException((ConfigurationNode)node, ex.getLocation(), ex.getRequestPayloadAsString(), ex.getMessage(), ex.getCause());
        }
        catch (IOException ex) {
            throw ParsingException.wrap((ConfigurationNode)node, (IOException)ex);
        }
    }

    private static void parseValue(JsonParser parser, ConfigurationNode node) throws IOException {
        try {
            JsonToken token = parser.getCurrentToken();
            switch (token) {
                case START_OBJECT: {
                    JacksonConfigurationLoader.parseObject(parser, node);
                    break;
                }
                case START_ARRAY: {
                    JacksonConfigurationLoader.parseArray(parser, node);
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    double doubleVal = parser.getDoubleValue();
                    if ((double)((float)doubleVal) != doubleVal) {
                        node.raw((Object)parser.getDoubleValue());
                        break;
                    }
                    node.raw((Object)Float.valueOf(parser.getFloatValue()));
                    break;
                }
                case VALUE_NUMBER_INT: {
                    long longVal = parser.getLongValue();
                    if ((long)((int)longVal) != longVal) {
                        node.raw((Object)parser.getLongValue());
                        break;
                    }
                    node.raw((Object)parser.getIntValue());
                    break;
                }
                case VALUE_STRING: {
                    node.raw((Object)parser.getText());
                    break;
                }
                case VALUE_TRUE: 
                case VALUE_FALSE: {
                    node.raw((Object)parser.getBooleanValue());
                    break;
                }
                case VALUE_NULL: 
                case FIELD_NAME: {
                    break;
                }
                default: {
                    JsonLocation loc = parser.getTokenLocation();
                    throw new ParsingException(node, loc.getLineNr(), loc.getColumnNr(), parser.getText(), "Unsupported token type: " + token, null);
                }
            }
        }
        catch (StreamReadException ex) {
            throw JacksonConfigurationLoader.newException(node, ex.getLocation(), ex.getRequestPayloadAsString(), ex.getMessage(), ex.getCause());
        }
    }

    private static void parseArray(JsonParser parser, ConfigurationNode node) throws IOException {
        JsonToken token;
        boolean written = false;
        while ((token = parser.nextToken()) != null) {
            if (token == JsonToken.END_ARRAY) {
                if (!written) {
                    node.raw(Collections.emptyList());
                }
                return;
            }
            JacksonConfigurationLoader.parseValue(parser, node.appendListNode());
            written = true;
        }
        throw JacksonConfigurationLoader.newException(node, parser.getCurrentLocation(), null, "Reached end of stream with unclosed array!", null);
    }

    private static void parseObject(JsonParser parser, ConfigurationNode node) throws IOException {
        JsonToken token;
        boolean written = false;
        while ((token = parser.nextToken()) != null) {
            if (token == JsonToken.END_OBJECT) {
                if (!written) {
                    node.raw(Collections.emptyMap());
                }
                return;
            }
            JacksonConfigurationLoader.parseValue(parser, node.node(new Object[]{parser.getCurrentName()}));
            written = true;
        }
        throw JacksonConfigurationLoader.newException(node, parser.getCurrentLocation(), null, "Reached end of stream with unclosed object!", null);
    }

    protected void saveInternal(ConfigurationNode node, Writer writer) throws ConfigurateException {
        try (JsonGenerator generator = this.factory.createGenerator(writer);){
            generator.setPrettyPrinter((PrettyPrinter)new ConfiguratePrettyPrinter(this.indent, this.fieldValueSeparatorStyle));
            node.visit((ConfigurationVisitor)JacksonVisitor.INSTANCE.get(), (Object)generator);
            writer.write(SYSTEM_LINE_SEPARATOR);
        }
        catch (IOException ex) {
            throw ConfigurateException.wrap((ConfigurationNode)node, (IOException)ex);
        }
    }

    public BasicConfigurationNode createNode(@NonNull ConfigurationOptions options) {
        return BasicConfigurationNode.root((ConfigurationOptions)options.nativeTypes(NATIVE_TYPES));
    }

    private static ParsingException newException(ConfigurationNode node, JsonLocation position, @Nullable String content, @Nullable String message, @Nullable Throwable cause) {
        String context;
        String string = context = content == null ? null : content.substring((int)position.getCharOffset());
        if (context != null) {
            int nextLine = context.indexOf(10);
            if (nextLine == -1) {
                nextLine = context.length();
            } else if (context.charAt(nextLine - 1) == '\r') {
                --nextLine;
            }
            context = nextLine > 80 ? context.substring(0, 80) + "..." : context.substring(0, nextLine);
        }
        return new ParsingException(node, position.getLineNr(), position.getColumnNr(), context, message, cause);
    }

    public static final class Builder
    extends AbstractConfigurationLoader.Builder<Builder, JacksonConfigurationLoader> {
        private final JsonFactoryBuilder factory = new JsonFactoryBuilder();
        private int indent = 2;
        private FieldValueSeparatorStyle fieldValueSeparatorStyle = FieldValueSeparatorStyle.SPACE_AFTER;

        Builder() {
            this.factory.enable(JsonReadFeature.ALLOW_JAVA_COMMENTS).enable(JsonReadFeature.ALLOW_YAML_COMMENTS).enable(JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER).enable(JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES).enable(JsonReadFeature.ALLOW_SINGLE_QUOTES).enable(JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS).enable(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS);
        }

        public JsonFactoryBuilder factoryBuilder() {
            return this.factory;
        }

        public Builder indent(int indent) {
            this.indent = indent;
            return this;
        }

        public int indent() {
            return this.indent;
        }

        public Builder fieldValueSeparatorStyle(FieldValueSeparatorStyle style) {
            this.fieldValueSeparatorStyle = style;
            return this;
        }

        public FieldValueSeparatorStyle fieldValueSeparatorStyle() {
            return this.fieldValueSeparatorStyle;
        }

        public JacksonConfigurationLoader build() {
            this.defaultOptions(o -> o.nativeTypes(NATIVE_TYPES));
            return new JacksonConfigurationLoader(this);
        }
    }
}

