/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.objectmapping.guice;

import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.spongepowered.configurate.objectmapping.FieldDiscoverer;
import org.spongepowered.configurate.objectmapping.ObjectMapper;
import org.spongepowered.configurate.serialize.SerializationException;

@Singleton
public final class GuiceObjectMapperProvider {
    private final ObjectMapper.Factory factory;

    @Inject
    GuiceObjectMapperProvider(Injector baseInjector) {
        this.factory = ObjectMapper.factoryBuilder().addDiscoverer(GuiceObjectMapperProvider.injectedObjectDiscoverer(baseInjector)).build();
    }

    public ObjectMapper.Factory get() {
        return this.factory;
    }

    public static FieldDiscoverer<?> injectedObjectDiscoverer(Injector injector) {
        return FieldDiscoverer.object(type -> {
            try {
                Provider prov = injector.getProvider(Key.get((Type)type.getType()));
                return () -> ((Provider)prov).get();
            }
            catch (ConfigurationException ex) {
                throw new SerializationException(type.getType(), "Cannot create instances", (Throwable)ex);
            }
        });
    }

    public String toString() {
        return "GuiceObjectMapperFactory{}";
    }
}

