/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.junit4;

import java.util.List;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.spockframework.junit4.AbstractRuleInterceptor;
import org.spockframework.junit4.JUnitDescriptionGenerator;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.SpecInfo;

public class TestRuleInterceptor
extends AbstractRuleInterceptor {
    private final SpecInfo spec;

    public TestRuleInterceptor(List<FieldInfo> ruleFields, SpecInfo spec) {
        super(ruleFields);
        this.spec = spec;
    }

    public void intercept(IMethodInvocation invocation) throws Throwable {
        Statement stat = this.createBaseStatement(invocation);
        Description description = JUnitDescriptionGenerator.describeIteration(invocation.getIteration(), this.spec);
        for (FieldInfo field : this.ruleFields) {
            TestRule rule = (TestRule)this.getRuleInstance(field, invocation.getInstance());
            stat = rule.apply(stat, description);
        }
        this.evaluateStatement(stat);
    }
}

