/**
 * Copyright (c) 2024 Source Auditor Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 * 
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
 
package org.spdx.library.model.v3_0_1.security;

import javax.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.storage.IModelStore;
import org.spdx.storage.IModelStore.IdType;
import org.spdx.storage.IModelStore.IModelStoreLock;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.Agent;
import org.spdx.library.model.v3_0_1.core.Artifact;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.core.SupportType;
import org.spdx.library.model.v3_0_1.extension.Extension;

/**
 * DO NOT EDIT - this file is generated by the Owl to Java Utility 
 * See: https://github.com/spdx/tools-java 
 * 
 * Specifies a vulnerability and its associated information. 
 */
public  class Vulnerability extends Artifact  {

	
	/**
	 * Create the Vulnerability with default model store and generated anonymous ID
	 * @throws InvalidSPDXAnalysisException when unable to create the Vulnerability
	 */
	public Vulnerability() throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore().getNextId(IdType.Anonymous));
	}

	/**
	 * @param objectUri URI or anonymous ID for the Vulnerability
	 * @throws InvalidSPDXAnalysisException when unable to create the Vulnerability
	 */
	public Vulnerability(String objectUri) throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), 
				true, DefaultModelStore.getDefaultDocumentUri() + "#");
	}

	/**
	 * @param modelStore Model store where the Vulnerability is to be stored
	 * @param objectUri URI or anonymous ID for the Vulnerability
	 * @param copyManager Copy manager for the Vulnerability - can be null if copying is not required
	 * @param create true if Vulnerability is to be created
	 * @param idPrefix - prefix to be used when generating new SPDX IDs
	 * @throws InvalidSPDXAnalysisException when unable to create the Vulnerability
	 */
	 @SuppressWarnings("unchecked")
	public Vulnerability(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager,
			boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
		super(modelStore, objectUri, copyManager, create, idPrefix);
	}

	/**
	 * Create the Vulnerability from the builder - used in the builder class
	 * @param builder Builder to create the Vulnerability from
	 * @throws InvalidSPDXAnalysisException when unable to create the Vulnerability
	 */
	 @SuppressWarnings("unchecked")
	protected Vulnerability(VulnerabilityBuilder builder) throws InvalidSPDXAnalysisException {
		super(builder);
		setPublishedTime(builder.publishedTime);
		setWithdrawnTime(builder.withdrawnTime);
		setModifiedTime(builder.modifiedTime);
	}

	/* (non-Javadoc)
	 * @see org.spdx.library.core.CoreModelObject#getType()
	 */
	@Override
	public String getType() {
		return "Security.Vulnerability";
	}
	
	// Getters and Setters
	
	/**
	 * @param creationInfo the creationInfo to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Vulnerability setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
		super.setCreationInfo(creationInfo);
		return this;
	}	
	/**
	 * @param suppliedBy the suppliedBy to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Vulnerability setSuppliedBy(@Nullable Agent suppliedBy) throws InvalidSPDXAnalysisException {
		super.setSuppliedBy(suppliedBy);
		return this;
	}	
		/**
	 * @return the publishedTime
	 */
	public Optional<String> getPublishedTime() throws InvalidSPDXAnalysisException {
		return getStringPropertyValue(SpdxConstantsV3.PROP_PUBLISHED_TIME);
	}
	/**
	 * @param publishedTime the publishedTime to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public Vulnerability setPublishedTime(@Nullable String publishedTime) throws InvalidSPDXAnalysisException {
		if (isStrict() && Objects.nonNull(publishedTime) && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", publishedTime)) {
			throw new InvalidSPDXAnalysisException("publishedTime value '" + publishedTime + 
				"' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
		}
		setPropertyValue(SpdxConstantsV3.PROP_PUBLISHED_TIME, publishedTime);
		return this;
	}
	/**
	 * @param validUntilTime the validUntilTime to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Vulnerability setValidUntilTime(@Nullable String validUntilTime) throws InvalidSPDXAnalysisException {
		super.setValidUntilTime(validUntilTime);
		return this;
	}	
	/**
	 * @param builtTime the builtTime to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Vulnerability setBuiltTime(@Nullable String builtTime) throws InvalidSPDXAnalysisException {
		super.setBuiltTime(builtTime);
		return this;
	}	
	/**
	 * @param summary the summary to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Vulnerability setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
		super.setSummary(summary);
		return this;
	}	
	/**
	 * @param description the description to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Vulnerability setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
		super.setDescription(description);
		return this;
	}	
	/**
	 * @param releaseTime the releaseTime to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Vulnerability setReleaseTime(@Nullable String releaseTime) throws InvalidSPDXAnalysisException {
		super.setReleaseTime(releaseTime);
		return this;
	}	
		/**
	 * @return the withdrawnTime
	 */
	public Optional<String> getWithdrawnTime() throws InvalidSPDXAnalysisException {
		return getStringPropertyValue(SpdxConstantsV3.PROP_WITHDRAWN_TIME);
	}
	/**
	 * @param withdrawnTime the withdrawnTime to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public Vulnerability setWithdrawnTime(@Nullable String withdrawnTime) throws InvalidSPDXAnalysisException {
		if (isStrict() && Objects.nonNull(withdrawnTime) && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", withdrawnTime)) {
			throw new InvalidSPDXAnalysisException("withdrawnTime value '" + withdrawnTime + 
				"' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
		}
		setPropertyValue(SpdxConstantsV3.PROP_WITHDRAWN_TIME, withdrawnTime);
		return this;
	}
	/**
	 * @param comment the comment to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Vulnerability setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
		super.setComment(comment);
		return this;
	}	
	/**
	 * @param name the name to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Vulnerability setName(@Nullable String name) throws InvalidSPDXAnalysisException {
		super.setName(name);
		return this;
	}	
		/**
	 * @return the modifiedTime
	 */
	public Optional<String> getModifiedTime() throws InvalidSPDXAnalysisException {
		return getStringPropertyValue(SpdxConstantsV3.PROP_MODIFIED_TIME);
	}
	/**
	 * @param modifiedTime the modifiedTime to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public Vulnerability setModifiedTime(@Nullable String modifiedTime) throws InvalidSPDXAnalysisException {
		if (isStrict() && Objects.nonNull(modifiedTime) && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", modifiedTime)) {
			throw new InvalidSPDXAnalysisException("modifiedTime value '" + modifiedTime + 
				"' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
		}
		setPropertyValue(SpdxConstantsV3.PROP_MODIFIED_TIME, modifiedTime);
		return this;
	}
	
	
	@Override
	public String toString() {
				return super.toString();
	}
	
	/* (non-Javadoc)
	 * @see org.spdx.library.model.v3.ModelObjectV3#_verify(java.util.List)
	 */
	@Override
	public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
		List<String> retval = new ArrayList<>();
		retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
		try {
			Optional<String> publishedTime = getPublishedTime();
			if (publishedTime.isPresent() && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", publishedTime.get())) {
				retval.add("publishedTime value '" + publishedTime.get() + 
					"' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting publishedTime for Vulnerability: "+e.getMessage());
		}
		try {
			Optional<String> withdrawnTime = getWithdrawnTime();
			if (withdrawnTime.isPresent() && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", withdrawnTime.get())) {
				retval.add("withdrawnTime value '" + withdrawnTime.get() + 
					"' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting withdrawnTime for Vulnerability: "+e.getMessage());
		}
		try {
			Optional<String> modifiedTime = getModifiedTime();
			if (modifiedTime.isPresent() && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", modifiedTime.get())) {
				retval.add("modifiedTime value '" + modifiedTime.get() + 
					"' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting modifiedTime for Vulnerability: "+e.getMessage());
		}
		return retval;
	}
	
	
	
	public static class VulnerabilityBuilder extends ArtifactBuilder {
	
		/**
		 * Create an VulnerabilityBuilder from another model object copying the modelStore and copyManager and using an anonymous ID
		 * @param from model object to copy the model store and copyManager from
		 * @throws InvalidSPDXAnalysisException
		 */
		public VulnerabilityBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
			this(from, from.getModelStore().getNextId(IdType.Anonymous));
		}
	
		/**
		 * Create an VulnerabilityBuilder from another model object copying the modelStore and copyManager
		 * @param from model object to copy the model store and copyManager from
		 * @param objectUri URI for the object
		 * @throws InvalidSPDXAnalysisException if creationInfo can not be fetched from the from
		 */
		public VulnerabilityBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
			this(from.getModelStore(), objectUri, from.getCopyManager());
			setStrict(from.isStrict());
			setIdPrefix(from.getIdPrefix());
			if (from instanceof Element) {
				setCreationInfo(((Element)from).getCreationInfo());
			} else if (from instanceof CreationInfo) {
				setCreationInfo((CreationInfo)from);
			}
		}
		
		/**
		 * Creates a VulnerabilityBuilder
		 * @param modelStore model store for the built Vulnerability
		 * @param objectUri objectUri for the built Vulnerability
		 * @param copyManager optional copyManager for the built Vulnerability
		 */
		public VulnerabilityBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
			super(modelStore, objectUri, copyManager);
		}
		
		protected String publishedTime = null;
		protected String withdrawnTime = null;
		protected String modifiedTime = null;
		
		
		/**
		 * Adds a extension to the initial collection
		 * @parameter extension extension to add
		 * @return this for chaining
		**/
		public VulnerabilityBuilder addExtension(Extension extension) {
			if (Objects.nonNull(extension)) {
				super.extensions.add(extension);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial extension collection
		 * @parameter extensionCollection collection to initialize the extension
		 * @return this for chaining
		**/
		public VulnerabilityBuilder addAllExtension(Collection<Extension> extensionCollection) {
			if (Objects.nonNull(extensionCollection)) {
				super.extensions.addAll(extensionCollection);
			}
			return this;
		}
		
		/**
		 * Adds a verifiedUsing to the initial collection
		 * @parameter verifiedUsing verifiedUsing to add
		 * @return this for chaining
		**/
		public VulnerabilityBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
			if (Objects.nonNull(verifiedUsing)) {
				super.verifiedUsings.add(verifiedUsing);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial verifiedUsing collection
		 * @parameter verifiedUsingCollection collection to initialize the verifiedUsing
		 * @return this for chaining
		**/
		public VulnerabilityBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
			if (Objects.nonNull(verifiedUsingCollection)) {
				super.verifiedUsings.addAll(verifiedUsingCollection);
			}
			return this;
		}
		
		/**
		 * Adds a originatedBy to the initial collection
		 * @parameter originatedBy originatedBy to add
		 * @return this for chaining
		**/
		public VulnerabilityBuilder addOriginatedBy(Agent originatedBy) {
			if (Objects.nonNull(originatedBy)) {
				super.originatedBys.add(originatedBy);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial originatedBy collection
		 * @parameter originatedByCollection collection to initialize the originatedBy
		 * @return this for chaining
		**/
		public VulnerabilityBuilder addAllOriginatedBy(Collection<Agent> originatedByCollection) {
			if (Objects.nonNull(originatedByCollection)) {
				super.originatedBys.addAll(originatedByCollection);
			}
			return this;
		}
		
		/**
		 * Adds a externalRef to the initial collection
		 * @parameter externalRef externalRef to add
		 * @return this for chaining
		**/
		public VulnerabilityBuilder addExternalRef(ExternalRef externalRef) {
			if (Objects.nonNull(externalRef)) {
				super.externalRefs.add(externalRef);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial externalRef collection
		 * @parameter externalRefCollection collection to initialize the externalRef
		 * @return this for chaining
		**/
		public VulnerabilityBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
			if (Objects.nonNull(externalRefCollection)) {
				super.externalRefs.addAll(externalRefCollection);
			}
			return this;
		}
		
		/**
		 * Adds a externalIdentifier to the initial collection
		 * @parameter externalIdentifier externalIdentifier to add
		 * @return this for chaining
		**/
		public VulnerabilityBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
			if (Objects.nonNull(externalIdentifier)) {
				super.externalIdentifiers.add(externalIdentifier);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial externalIdentifier collection
		 * @parameter externalIdentifierCollection collection to initialize the externalIdentifier
		 * @return this for chaining
		**/
		public VulnerabilityBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
			if (Objects.nonNull(externalIdentifierCollection)) {
				super.externalIdentifiers.addAll(externalIdentifierCollection);
			}
			return this;
		}
		
		/**
		 * Adds a supportLevel to the initial collection
		 * @parameter supportLevel supportLevel to add
		 * @return this for chaining
		**/
		public VulnerabilityBuilder addSupportLevel(SupportType supportLevel) {
			if (Objects.nonNull(supportLevel)) {
				super.supportLevels.add(supportLevel);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial supportLevel collection
		 * @parameter supportLevelCollection collection to initialize the supportLevel
		 * @return this for chaining
		**/
		public VulnerabilityBuilder addAllSupportLevel(Collection<SupportType> supportLevelCollection) {
			if (Objects.nonNull(supportLevelCollection)) {
				super.supportLevels.addAll(supportLevelCollection);
			}
			return this;
		}
		
		/**
		 * Adds a standardName to the initial collection
		 * @parameter standardName standardName to add
		 * @return this for chaining
		**/
		public VulnerabilityBuilder addStandardName(String standardName) {
			if (Objects.nonNull(standardName)) {
				super.standardNames.add(standardName);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial standardName collection
		 * @parameter standardNameCollection collection to initialize the standardName
		 * @return this for chaining
		**/
		public VulnerabilityBuilder addAllStandardName(Collection<String> standardNameCollection) {
			if (Objects.nonNull(standardNameCollection)) {
				super.standardNames.addAll(standardNameCollection);
			}
			return this;
		}
		
		/**
		 * Sets the initial value of creationInfo
		 * @parameter creationInfo value to set
		 * @return this for chaining
		**/
		public VulnerabilityBuilder setCreationInfo(CreationInfo creationInfo) {
			super.creationInfo = creationInfo;
			return this;
		}
		
		/**
		 * Sets the initial value of suppliedBy
		 * @parameter suppliedBy value to set
		 * @return this for chaining
		**/
		public VulnerabilityBuilder setSuppliedBy(Agent suppliedBy) {
			super.suppliedBy = suppliedBy;
			return this;
		}
		
		/**
		 * Sets the initial value of publishedTime
		 * @parameter publishedTime value to set
		 * @return this for chaining
		**/
		public VulnerabilityBuilder setPublishedTime(String publishedTime) {
			this.publishedTime = publishedTime;
			return this;
		}
		
		/**
		 * Sets the initial value of validUntilTime
		 * @parameter validUntilTime value to set
		 * @return this for chaining
		**/
		public VulnerabilityBuilder setValidUntilTime(String validUntilTime) {
			super.validUntilTime = validUntilTime;
			return this;
		}
		
		/**
		 * Sets the initial value of builtTime
		 * @parameter builtTime value to set
		 * @return this for chaining
		**/
		public VulnerabilityBuilder setBuiltTime(String builtTime) {
			super.builtTime = builtTime;
			return this;
		}
		
		/**
		 * Sets the initial value of summary
		 * @parameter summary value to set
		 * @return this for chaining
		**/
		public VulnerabilityBuilder setSummary(String summary) {
			super.summary = summary;
			return this;
		}
		
		/**
		 * Sets the initial value of description
		 * @parameter description value to set
		 * @return this for chaining
		**/
		public VulnerabilityBuilder setDescription(String description) {
			super.description = description;
			return this;
		}
		
		/**
		 * Sets the initial value of releaseTime
		 * @parameter releaseTime value to set
		 * @return this for chaining
		**/
		public VulnerabilityBuilder setReleaseTime(String releaseTime) {
			super.releaseTime = releaseTime;
			return this;
		}
		
		/**
		 * Sets the initial value of withdrawnTime
		 * @parameter withdrawnTime value to set
		 * @return this for chaining
		**/
		public VulnerabilityBuilder setWithdrawnTime(String withdrawnTime) {
			this.withdrawnTime = withdrawnTime;
			return this;
		}
		
		/**
		 * Sets the initial value of comment
		 * @parameter comment value to set
		 * @return this for chaining
		**/
		public VulnerabilityBuilder setComment(String comment) {
			super.comment = comment;
			return this;
		}
		
		/**
		 * Sets the initial value of name
		 * @parameter name value to set
		 * @return this for chaining
		**/
		public VulnerabilityBuilder setName(String name) {
			super.name = name;
			return this;
		}
		
		/**
		 * Sets the initial value of modifiedTime
		 * @parameter modifiedTime value to set
		 * @return this for chaining
		**/
		public VulnerabilityBuilder setModifiedTime(String modifiedTime) {
			this.modifiedTime = modifiedTime;
			return this;
		}
	
		/**
		 * @return the Vulnerability
		 * @throws InvalidSPDXAnalysisException on any errors during build
		 */
		public Vulnerability build() throws InvalidSPDXAnalysisException {
			IModelStoreLock lock = getModelStore().enterCriticalSection(false);
			try {
				return new Vulnerability(this);
			} finally {
				getModelStore().leaveCriticalSection(lock);
			}
		}
	}
}
