/**
 * Copyright (c) 2024 Source Auditor Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 * 
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
 
package org.spdx.library.model.v3_0_1.expandedlicensing;

import javax.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.storage.IModelStore;
import org.spdx.storage.IModelStore.IdType;
import org.spdx.storage.IModelStore.IModelStoreLock;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo;

/**
 * DO NOT EDIT - this file is generated by the Owl to Java Utility 
 * See: https://github.com/spdx/tools-java 
 * 
 * Portion of an AnyLicenseInfo representing a License which has additional text applied 
 * to it. 
 */
public  class WithAdditionOperator extends AnyLicenseInfo  {

	
	/**
	 * Create the WithAdditionOperator with default model store and generated anonymous ID
	 * @throws InvalidSPDXAnalysisException when unable to create the WithAdditionOperator
	 */
	public WithAdditionOperator() throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore().getNextId(IdType.Anonymous));
	}

	/**
	 * @param objectUri URI or anonymous ID for the WithAdditionOperator
	 * @throws InvalidSPDXAnalysisException when unable to create the WithAdditionOperator
	 */
	public WithAdditionOperator(String objectUri) throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), 
				true, DefaultModelStore.getDefaultDocumentUri() + "#");
	}

	/**
	 * @param modelStore Model store where the WithAdditionOperator is to be stored
	 * @param objectUri URI or anonymous ID for the WithAdditionOperator
	 * @param copyManager Copy manager for the WithAdditionOperator - can be null if copying is not required
	 * @param create true if WithAdditionOperator is to be created
	 * @param idPrefix - prefix to be used when generating new SPDX IDs
	 * @throws InvalidSPDXAnalysisException when unable to create the WithAdditionOperator
	 */
	 @SuppressWarnings("unchecked")
	public WithAdditionOperator(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager,
			boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
		super(modelStore, objectUri, copyManager, create, idPrefix);
	}

	/**
	 * Create the WithAdditionOperator from the builder - used in the builder class
	 * @param builder Builder to create the WithAdditionOperator from
	 * @throws InvalidSPDXAnalysisException when unable to create the WithAdditionOperator
	 */
	 @SuppressWarnings("unchecked")
	protected WithAdditionOperator(WithAdditionOperatorBuilder builder) throws InvalidSPDXAnalysisException {
		super(builder);
		if (Objects.nonNull(builder.subjectAddition)) {
			setSubjectAddition(builder.subjectAddition);
		}
		if (Objects.nonNull(builder.subjectExtendableLicense)) {
			setSubjectExtendableLicense(builder.subjectExtendableLicense);
		}
	}

	/* (non-Javadoc)
	 * @see org.spdx.library.core.CoreModelObject#getType()
	 */
	@Override
	public String getType() {
		return "ExpandedLicensing.WithAdditionOperator";
	}
	
	// Getters and Setters
	
	/**
	 * @param creationInfo the creationInfo to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public WithAdditionOperator setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
		super.setCreationInfo(creationInfo);
		return this;
	}	
	/**
	 * @return the subjectAddition
	 */
	public @Nullable LicenseAddition getSubjectAddition() throws InvalidSPDXAnalysisException {
		Optional<LicenseAddition> retval = getLicenseAdditionPropertyValue(SpdxConstantsV3.PROP_SUBJECT_ADDITION);
		return retval.isPresent() ? retval.get() : null;
	}
		
	/**
	 * @param subjectAddition the subjectAddition to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public WithAdditionOperator setSubjectAddition(@Nullable LicenseAddition subjectAddition) throws InvalidSPDXAnalysisException {
		if (isStrict() && Objects.isNull(subjectAddition)) {
			throw new InvalidSPDXAnalysisException("subjectAddition is a required property");
		}
		setPropertyValue(SpdxConstantsV3.PROP_SUBJECT_ADDITION, subjectAddition);
		return this;
	}
	/**
	 * @return the subjectExtendableLicense
	 */
	public @Nullable ExtendableLicense getSubjectExtendableLicense() throws InvalidSPDXAnalysisException {
		Optional<ExtendableLicense> retval = getExtendableLicensePropertyValue(SpdxConstantsV3.PROP_SUBJECT_EXTENDABLE_LICENSE);
		return retval.isPresent() ? retval.get() : null;
	}
		
	/**
	 * @param subjectExtendableLicense the subjectExtendableLicense to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public WithAdditionOperator setSubjectExtendableLicense(@Nullable ExtendableLicense subjectExtendableLicense) throws InvalidSPDXAnalysisException {
		if (isStrict() && Objects.isNull(subjectExtendableLicense)) {
			throw new InvalidSPDXAnalysisException("subjectExtendableLicense is a required property");
		}
		setPropertyValue(SpdxConstantsV3.PROP_SUBJECT_EXTENDABLE_LICENSE, subjectExtendableLicense);
		return this;
	}
	/**
	 * @param summary the summary to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public WithAdditionOperator setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
		super.setSummary(summary);
		return this;
	}	
	/**
	 * @param description the description to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public WithAdditionOperator setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
		super.setDescription(description);
		return this;
	}	
	/**
	 * @param comment the comment to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public WithAdditionOperator setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
		super.setComment(comment);
		return this;
	}	
	/**
	 * @param name the name to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public WithAdditionOperator setName(@Nullable String name) throws InvalidSPDXAnalysisException {
		super.setName(name);
		return this;
	}	
	
	
	@Override
	public String toString() {
		try {
			String extendableLicenseStr = Objects.nonNull(this.getSubjectExtendableLicense()) ?
						this.getSubjectExtendableLicense().toString() : "[Missing extendableLicense]";
			String subjectAdditionStr = Objects.nonNull(this.getSubjectAddition()) ?
						this.getSubjectAddition().toString() : "[Missing subjectAddition]";
			return extendableLicenseStr + " WITH " + subjectAdditionStr;
		} catch (InvalidSPDXAnalysisException e) {
			return "Error: "+e.getMessage();
		}
	}
	
	/* (non-Javadoc)
	 * @see org.spdx.library.model.v3.ModelObjectV3#_verify(java.util.List)
	 */
	@Override
	public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
		List<String> retval = new ArrayList<>();
		retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
		LicenseAddition subjectAddition;
		try {
			subjectAddition = getSubjectAddition();
			if (Objects.nonNull(subjectAddition)) {
				retval.addAll(subjectAddition.verify(verifiedIds, specVersionForVerify, profiles));
			} else if (!Collections.disjoint(profiles, Arrays.asList(new ProfileIdentifierType[] { ProfileIdentifierType.EXPANDED_LICENSING }))) {
					retval.add("Missing subjectAddition in WithAdditionOperator");
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting subjectAddition for WithAdditionOperator: "+e.getMessage());
		}
		ExtendableLicense subjectExtendableLicense;
		try {
			subjectExtendableLicense = getSubjectExtendableLicense();
			if (Objects.nonNull(subjectExtendableLicense)) {
				retval.addAll(subjectExtendableLicense.verify(verifiedIds, specVersionForVerify, profiles));
			} else if (!Collections.disjoint(profiles, Arrays.asList(new ProfileIdentifierType[] { ProfileIdentifierType.EXPANDED_LICENSING }))) {
					retval.add("Missing subjectExtendableLicense in WithAdditionOperator");
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting subjectExtendableLicense for WithAdditionOperator: "+e.getMessage());
		}
		return retval;
	}
	
		/* (non-Javadoc)
	 * @see org.spdx.library.model.compat.v2.compat.v2.ModelObject#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object o) {
		if (!(o instanceof WithAdditionOperator)) {
			return false;
		}
		WithAdditionOperator comp = (WithAdditionOperator)o;
		ExtendableLicense myLicense = null;
		ExtendableLicense compLicense = null;
		LicenseAddition myException = null;
		LicenseAddition compException = null;
		try {
			myLicense = this.getSubjectExtendableLicense();
		} catch (InvalidSPDXAnalysisException e) {
			// Likely caused by missing required field - leave the value as null
		}
		try {
			compLicense = comp.getSubjectExtendableLicense();
		} catch (InvalidSPDXAnalysisException e) {
			// Likely caused by missing required field - leave the value as null
		}
		try {
			myException = this.getSubjectAddition();
		} catch (InvalidSPDXAnalysisException e) {
			// Likely caused by missing required field - leave the value as null
		}
		try {
			compException = comp.getSubjectAddition();
		} catch (InvalidSPDXAnalysisException e) {
			// Likely caused by missing required field - leave the value as null
		}
		if (!Objects.equals(myLicense, compLicense)) {
			return false;
		}
		if (!Objects.equals(myException, compException)) {
			return false;
		}
		return true;	
	}
	
	/* (non-Javadoc)
	 * @see org.spdx.library.model.compat.v2.compat.v2.ModelObject#hashCode()
	 */
	@Override
	public int hashCode() {
		int licHashCode = 0;
		int exceptionHashCode = 0;
		try {
			licHashCode = this.getSubjectExtendableLicense().hashCode();
		} catch (InvalidSPDXAnalysisException e) {
			// Likely caused by missing required field - leave the value as 0
		}
		try {
			exceptionHashCode = this.getSubjectAddition().hashCode();
		} catch (InvalidSPDXAnalysisException e) {
			// Likely caused by missing required field - leave the value as 0
		}
		return 977 ^ licHashCode ^ exceptionHashCode;
	}
	
	public static class WithAdditionOperatorBuilder extends AnyLicenseInfoBuilder {
	
		/**
		 * Create an WithAdditionOperatorBuilder from another model object copying the modelStore and copyManager and using an anonymous ID
		 * @param from model object to copy the model store and copyManager from
		 * @throws InvalidSPDXAnalysisException
		 */
		public WithAdditionOperatorBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
			this(from, from.getModelStore().getNextId(IdType.Anonymous));
		}
	
		/**
		 * Create an WithAdditionOperatorBuilder from another model object copying the modelStore and copyManager
		 * @param from model object to copy the model store and copyManager from
		 * @param objectUri URI for the object
		 * @throws InvalidSPDXAnalysisException if creationInfo can not be fetched from the from
		 */
		public WithAdditionOperatorBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
			this(from.getModelStore(), objectUri, from.getCopyManager());
			setStrict(from.isStrict());
			setIdPrefix(from.getIdPrefix());
			if (from instanceof Element) {
				setCreationInfo(((Element)from).getCreationInfo());
			} else if (from instanceof CreationInfo) {
				setCreationInfo((CreationInfo)from);
			}
		}
		
		/**
		 * Creates a WithAdditionOperatorBuilder
		 * @param modelStore model store for the built WithAdditionOperator
		 * @param objectUri objectUri for the built WithAdditionOperator
		 * @param copyManager optional copyManager for the built WithAdditionOperator
		 */
		public WithAdditionOperatorBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
			super(modelStore, objectUri, copyManager);
		}
		
		protected LicenseAddition subjectAddition = null;
		protected ExtendableLicense subjectExtendableLicense = null;
		
		
		/**
		 * Adds a externalRef to the initial collection
		 * @parameter externalRef externalRef to add
		 * @return this for chaining
		**/
		public WithAdditionOperatorBuilder addExternalRef(ExternalRef externalRef) {
			if (Objects.nonNull(externalRef)) {
				super.externalRefs.add(externalRef);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial externalRef collection
		 * @parameter externalRefCollection collection to initialize the externalRef
		 * @return this for chaining
		**/
		public WithAdditionOperatorBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
			if (Objects.nonNull(externalRefCollection)) {
				super.externalRefs.addAll(externalRefCollection);
			}
			return this;
		}
		
		/**
		 * Adds a extension to the initial collection
		 * @parameter extension extension to add
		 * @return this for chaining
		**/
		public WithAdditionOperatorBuilder addExtension(Extension extension) {
			if (Objects.nonNull(extension)) {
				super.extensions.add(extension);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial extension collection
		 * @parameter extensionCollection collection to initialize the extension
		 * @return this for chaining
		**/
		public WithAdditionOperatorBuilder addAllExtension(Collection<Extension> extensionCollection) {
			if (Objects.nonNull(extensionCollection)) {
				super.extensions.addAll(extensionCollection);
			}
			return this;
		}
		
		/**
		 * Adds a verifiedUsing to the initial collection
		 * @parameter verifiedUsing verifiedUsing to add
		 * @return this for chaining
		**/
		public WithAdditionOperatorBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
			if (Objects.nonNull(verifiedUsing)) {
				super.verifiedUsings.add(verifiedUsing);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial verifiedUsing collection
		 * @parameter verifiedUsingCollection collection to initialize the verifiedUsing
		 * @return this for chaining
		**/
		public WithAdditionOperatorBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
			if (Objects.nonNull(verifiedUsingCollection)) {
				super.verifiedUsings.addAll(verifiedUsingCollection);
			}
			return this;
		}
		
		/**
		 * Adds a externalIdentifier to the initial collection
		 * @parameter externalIdentifier externalIdentifier to add
		 * @return this for chaining
		**/
		public WithAdditionOperatorBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
			if (Objects.nonNull(externalIdentifier)) {
				super.externalIdentifiers.add(externalIdentifier);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial externalIdentifier collection
		 * @parameter externalIdentifierCollection collection to initialize the externalIdentifier
		 * @return this for chaining
		**/
		public WithAdditionOperatorBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
			if (Objects.nonNull(externalIdentifierCollection)) {
				super.externalIdentifiers.addAll(externalIdentifierCollection);
			}
			return this;
		}
		
		/**
		 * Sets the initial value of creationInfo
		 * @parameter creationInfo value to set
		 * @return this for chaining
		**/
		public WithAdditionOperatorBuilder setCreationInfo(CreationInfo creationInfo) {
			super.creationInfo = creationInfo;
			return this;
		}
		
		/**
		 * Sets the initial value of subjectAddition
		 * @parameter subjectAddition value to set
		 * @return this for chaining
		**/
		public WithAdditionOperatorBuilder setSubjectAddition(LicenseAddition subjectAddition) {
			this.subjectAddition = subjectAddition;
			return this;
		}
		
		/**
		 * Sets the initial value of subjectExtendableLicense
		 * @parameter subjectExtendableLicense value to set
		 * @return this for chaining
		**/
		public WithAdditionOperatorBuilder setSubjectExtendableLicense(ExtendableLicense subjectExtendableLicense) {
			this.subjectExtendableLicense = subjectExtendableLicense;
			return this;
		}
		
		/**
		 * Sets the initial value of summary
		 * @parameter summary value to set
		 * @return this for chaining
		**/
		public WithAdditionOperatorBuilder setSummary(String summary) {
			super.summary = summary;
			return this;
		}
		
		/**
		 * Sets the initial value of description
		 * @parameter description value to set
		 * @return this for chaining
		**/
		public WithAdditionOperatorBuilder setDescription(String description) {
			super.description = description;
			return this;
		}
		
		/**
		 * Sets the initial value of comment
		 * @parameter comment value to set
		 * @return this for chaining
		**/
		public WithAdditionOperatorBuilder setComment(String comment) {
			super.comment = comment;
			return this;
		}
		
		/**
		 * Sets the initial value of name
		 * @parameter name value to set
		 * @return this for chaining
		**/
		public WithAdditionOperatorBuilder setName(String name) {
			super.name = name;
			return this;
		}
	
		/**
		 * @return the WithAdditionOperator
		 * @throws InvalidSPDXAnalysisException on any errors during build
		 */
		public WithAdditionOperator build() throws InvalidSPDXAnalysisException {
			IModelStoreLock lock = getModelStore().enterCriticalSection(false);
			try {
				return new WithAdditionOperator(this);
			} finally {
				getModelStore().leaveCriticalSection(lock);
			}
		}
	}
}
