/**
 * Copyright (c) 2024 Source Auditor Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 * 
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
 
package org.spdx.library.model.v3_0_1.dataset;

import javax.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.storage.IModelStore;
import org.spdx.storage.IModelStore.IdType;
import org.spdx.storage.IModelStore.IModelStoreLock;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.Agent;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.DictionaryEntry;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.PresenceType;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.core.SupportType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.library.model.v3_0_1.software.ContentIdentifier;
import org.spdx.library.model.v3_0_1.software.SoftwarePurpose;
import org.spdx.library.model.v3_0_1.software.SpdxPackage;

/**
 * DO NOT EDIT - this file is generated by the Owl to Java Utility 
 * See: https://github.com/spdx/tools-java 
 * 
 * Specifies a data package and its associated information. 
 */
public  class DatasetPackage extends SpdxPackage  {

	Collection<DictionaryEntry> sensors = Collections.emptyList();
	Collection<String> anonymizationMethodUseds = Collections.emptyList();
	Collection<String> knownBiass = Collections.emptyList();
	Collection<String> dataPreprocessings = Collections.emptyList();
	Collection<DatasetType> datasetTypes = Collections.emptyList();
	
	/**
	 * Create the DatasetPackage with default model store and generated anonymous ID
	 * @throws InvalidSPDXAnalysisException when unable to create the DatasetPackage
	 */
	public DatasetPackage() throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore().getNextId(IdType.Anonymous));
	}

	/**
	 * @param objectUri URI or anonymous ID for the DatasetPackage
	 * @throws InvalidSPDXAnalysisException when unable to create the DatasetPackage
	 */
	public DatasetPackage(String objectUri) throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), 
				true, DefaultModelStore.getDefaultDocumentUri() + "#");
	}

	/**
	 * @param modelStore Model store where the DatasetPackage is to be stored
	 * @param objectUri URI or anonymous ID for the DatasetPackage
	 * @param copyManager Copy manager for the DatasetPackage - can be null if copying is not required
	 * @param create true if DatasetPackage is to be created
	 * @param idPrefix - prefix to be used when generating new SPDX IDs
	 * @throws InvalidSPDXAnalysisException when unable to create the DatasetPackage
	 */
	 @SuppressWarnings("unchecked")
	public DatasetPackage(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager,
			boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
		super(modelStore, objectUri, copyManager, create, idPrefix);
		if (!isExternal()) {
			sensors = (Collection<DictionaryEntry>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_SENSOR, DictionaryEntry.class);
		}
		if (!isExternal()) {
			datasetTypes = (Collection<DatasetType>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_DATASET_TYPE, DatasetType.class);
		}
		if (!isExternal()) {
			anonymizationMethodUseds = (Collection<String>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_ANONYMIZATION_METHOD_USED, String.class);
		}
		if (!isExternal()) {
			knownBiass = (Collection<String>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_KNOWN_BIAS, String.class);
		}
		if (!isExternal()) {
			dataPreprocessings = (Collection<String>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_DATA_PREPROCESSING, String.class);
		}
	}

	/**
	 * Create the DatasetPackage from the builder - used in the builder class
	 * @param builder Builder to create the DatasetPackage from
	 * @throws InvalidSPDXAnalysisException when unable to create the DatasetPackage
	 */
	 @SuppressWarnings("unchecked")
	protected DatasetPackage(DatasetPackageBuilder builder) throws InvalidSPDXAnalysisException {
		super(builder);
		sensors = (Collection<DictionaryEntry>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_SENSOR, DictionaryEntry.class);
		datasetTypes = (Collection<DatasetType>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_DATASET_TYPE, DatasetType.class);
		anonymizationMethodUseds = (Collection<String>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_ANONYMIZATION_METHOD_USED, String.class);
		knownBiass = (Collection<String>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_KNOWN_BIAS, String.class);
		dataPreprocessings = (Collection<String>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_DATA_PREPROCESSING, String.class);
		getSensors().addAll(builder.sensors);
		getDatasetTypes().addAll(builder.datasetTypes);
		getAnonymizationMethodUseds().addAll(builder.anonymizationMethodUseds);
		getKnownBiass().addAll(builder.knownBiass);
		getDataPreprocessings().addAll(builder.dataPreprocessings);
		setDatasetAvailability(builder.datasetAvailability);
		setConfidentialityLevel(builder.confidentialityLevel);
		setHasSensitivePersonalInformation(builder.hasSensitivePersonalInformation);
		setDatasetSize(builder.datasetSize);
		setDatasetNoise(builder.datasetNoise);
		setIntendedUse(builder.intendedUse);
		setDataCollectionProcess(builder.dataCollectionProcess);
		setDatasetUpdateMechanism(builder.datasetUpdateMechanism);
	}

	/* (non-Javadoc)
	 * @see org.spdx.library.core.CoreModelObject#getType()
	 */
	@Override
	public String getType() {
		return "Dataset.DatasetPackage";
	}
	
	// Getters and Setters
	public Collection<DictionaryEntry> getSensors() {
		return sensors;
	}
	public Collection<DatasetType> getDatasetTypes() {
		return datasetTypes;
	}
	public Collection<String> getAnonymizationMethodUseds() {
		return anonymizationMethodUseds;
	}
	public Collection<String> getKnownBiass() {
		return knownBiass;
	}
	public Collection<String> getDataPreprocessings() {
		return dataPreprocessings;
	}
	
	/**
	 * @param creationInfo the creationInfo to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public DatasetPackage setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
		super.setCreationInfo(creationInfo);
		return this;
	}	
	/**
	 * @param suppliedBy the suppliedBy to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public DatasetPackage setSuppliedBy(@Nullable Agent suppliedBy) throws InvalidSPDXAnalysisException {
		super.setSuppliedBy(suppliedBy);
		return this;
	}	
	/**
	 * @return the datasetAvailability
	 */
	 @SuppressWarnings("unchecked")
	public Optional<DatasetAvailabilityType> getDatasetAvailability() throws InvalidSPDXAnalysisException {
		Optional<Enum<?>> retval = getEnumPropertyValue(SpdxConstantsV3.PROP_DATASET_AVAILABILITY);
		if (retval.isPresent()) {
			if (!(retval.get() instanceof DatasetAvailabilityType)) {
				throw new InvalidSPDXAnalysisException("Incorrect type stored for datasetAvailability");
			}
			return (Optional<DatasetAvailabilityType>)(Optional<?>)(retval);
		} else {
			return Optional.empty();
		}
	}
	/**
	 * @param datasetAvailability the datasetAvailability to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public DatasetPackage setDatasetAvailability(@Nullable DatasetAvailabilityType datasetAvailability) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_DATASET_AVAILABILITY, datasetAvailability);
		return this;
	}
	/**
	 * @return the confidentialityLevel
	 */
	 @SuppressWarnings("unchecked")
	public Optional<ConfidentialityLevelType> getConfidentialityLevel() throws InvalidSPDXAnalysisException {
		Optional<Enum<?>> retval = getEnumPropertyValue(SpdxConstantsV3.PROP_CONFIDENTIALITY_LEVEL);
		if (retval.isPresent()) {
			if (!(retval.get() instanceof ConfidentialityLevelType)) {
				throw new InvalidSPDXAnalysisException("Incorrect type stored for confidentialityLevel");
			}
			return (Optional<ConfidentialityLevelType>)(Optional<?>)(retval);
		} else {
			return Optional.empty();
		}
	}
	/**
	 * @param confidentialityLevel the confidentialityLevel to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public DatasetPackage setConfidentialityLevel(@Nullable ConfidentialityLevelType confidentialityLevel) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_CONFIDENTIALITY_LEVEL, confidentialityLevel);
		return this;
	}
	/**
	 * @return the hasSensitivePersonalInformation
	 */
	 @SuppressWarnings("unchecked")
	public Optional<PresenceType> getHasSensitivePersonalInformation() throws InvalidSPDXAnalysisException {
		Optional<Enum<?>> retval = getEnumPropertyValue(SpdxConstantsV3.PROP_HAS_SENSITIVE_PERSONAL_INFORMATION);
		if (retval.isPresent()) {
			if (!(retval.get() instanceof PresenceType)) {
				throw new InvalidSPDXAnalysisException("Incorrect type stored for hasSensitivePersonalInformation");
			}
			return (Optional<PresenceType>)(Optional<?>)(retval);
		} else {
			return Optional.empty();
		}
	}
	/**
	 * @param hasSensitivePersonalInformation the hasSensitivePersonalInformation to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public DatasetPackage setHasSensitivePersonalInformation(@Nullable PresenceType hasSensitivePersonalInformation) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_HAS_SENSITIVE_PERSONAL_INFORMATION, hasSensitivePersonalInformation);
		return this;
	}
	/**
	 * @param primaryPurpose the primaryPurpose to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public DatasetPackage setPrimaryPurpose(@Nullable SoftwarePurpose primaryPurpose) throws InvalidSPDXAnalysisException {
		super.setPrimaryPurpose(primaryPurpose);
		return this;
	}	
	/**
	 * @return the datasetSize
	 */
	public Optional<Integer> getDatasetSize() throws InvalidSPDXAnalysisException {
		return getIntegerPropertyValue(SpdxConstantsV3.PROP_DATASET_SIZE);
	}
	
	/**
	 * @param datasetSize the datasetSize to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public DatasetPackage setDatasetSize(@Nullable Integer datasetSize) throws InvalidSPDXAnalysisException {
		if (isStrict() && Objects.nonNull(datasetSize) && datasetSize < 0) {
			throw new InvalidSPDXAnalysisException("datasetSize value " + datasetSize + " is less than the minimum 0 in DatasetPackage");
		}
		setPropertyValue(SpdxConstantsV3.PROP_DATASET_SIZE, datasetSize);
		return this;
	}
	/**
	 * @param validUntilTime the validUntilTime to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public DatasetPackage setValidUntilTime(@Nullable String validUntilTime) throws InvalidSPDXAnalysisException {
		super.setValidUntilTime(validUntilTime);
		return this;
	}	
	/**
	 * @param downloadLocation the downloadLocation to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public DatasetPackage setDownloadLocation(@Nullable String downloadLocation) throws InvalidSPDXAnalysisException {
		super.setDownloadLocation(downloadLocation);
		return this;
	}	
	/**
	 * @param builtTime the builtTime to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public DatasetPackage setBuiltTime(@Nullable String builtTime) throws InvalidSPDXAnalysisException {
		super.setBuiltTime(builtTime);
		return this;
	}	
		/**
	 * @return the datasetNoise
	 */
	public Optional<String> getDatasetNoise() throws InvalidSPDXAnalysisException {
		return getStringPropertyValue(SpdxConstantsV3.PROP_DATASET_NOISE);
	}
	/**
	 * @param datasetNoise the datasetNoise to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public DatasetPackage setDatasetNoise(@Nullable String datasetNoise) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_DATASET_NOISE, datasetNoise);
		return this;
	}
	/**
	 * @param summary the summary to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public DatasetPackage setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
		super.setSummary(summary);
		return this;
	}	
	/**
	 * @param packageVersion the packageVersion to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public DatasetPackage setPackageVersion(@Nullable String packageVersion) throws InvalidSPDXAnalysisException {
		super.setPackageVersion(packageVersion);
		return this;
	}	
	/**
	 * @param releaseTime the releaseTime to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public DatasetPackage setReleaseTime(@Nullable String releaseTime) throws InvalidSPDXAnalysisException {
		super.setReleaseTime(releaseTime);
		return this;
	}	
	/**
	 * @param copyrightText the copyrightText to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public DatasetPackage setCopyrightText(@Nullable String copyrightText) throws InvalidSPDXAnalysisException {
		super.setCopyrightText(copyrightText);
		return this;
	}	
	/**
	 * @param comment the comment to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public DatasetPackage setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
		super.setComment(comment);
		return this;
	}	
	/**
	 * @param homePage the homePage to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public DatasetPackage setHomePage(@Nullable String homePage) throws InvalidSPDXAnalysisException {
		super.setHomePage(homePage);
		return this;
	}	
	/**
	 * @param sourceInfo the sourceInfo to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public DatasetPackage setSourceInfo(@Nullable String sourceInfo) throws InvalidSPDXAnalysisException {
		super.setSourceInfo(sourceInfo);
		return this;
	}	
		/**
	 * @return the intendedUse
	 */
	public Optional<String> getIntendedUse() throws InvalidSPDXAnalysisException {
		return getStringPropertyValue(SpdxConstantsV3.PROP_INTENDED_USE);
	}
	/**
	 * @param intendedUse the intendedUse to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public DatasetPackage setIntendedUse(@Nullable String intendedUse) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_INTENDED_USE, intendedUse);
		return this;
	}
	/**
	 * @param description the description to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public DatasetPackage setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
		super.setDescription(description);
		return this;
	}	
		/**
	 * @return the dataCollectionProcess
	 */
	public Optional<String> getDataCollectionProcess() throws InvalidSPDXAnalysisException {
		return getStringPropertyValue(SpdxConstantsV3.PROP_DATA_COLLECTION_PROCESS);
	}
	/**
	 * @param dataCollectionProcess the dataCollectionProcess to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public DatasetPackage setDataCollectionProcess(@Nullable String dataCollectionProcess) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_DATA_COLLECTION_PROCESS, dataCollectionProcess);
		return this;
	}
		/**
	 * @return the datasetUpdateMechanism
	 */
	public Optional<String> getDatasetUpdateMechanism() throws InvalidSPDXAnalysisException {
		return getStringPropertyValue(SpdxConstantsV3.PROP_DATASET_UPDATE_MECHANISM);
	}
	/**
	 * @param datasetUpdateMechanism the datasetUpdateMechanism to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public DatasetPackage setDatasetUpdateMechanism(@Nullable String datasetUpdateMechanism) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_DATASET_UPDATE_MECHANISM, datasetUpdateMechanism);
		return this;
	}
	/**
	 * @param name the name to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public DatasetPackage setName(@Nullable String name) throws InvalidSPDXAnalysisException {
		super.setName(name);
		return this;
	}	
	/**
	 * @param packageUrl the packageUrl to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public DatasetPackage setPackageUrl(@Nullable String packageUrl) throws InvalidSPDXAnalysisException {
		super.setPackageUrl(packageUrl);
		return this;
	}	
	
	
	@Override
	public String toString() {
				return super.toString();
	}
	
	/* (non-Javadoc)
	 * @see org.spdx.library.model.v3.ModelObjectV3#_verify(java.util.List)
	 */
	@Override
	public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
		List<String> retval = new ArrayList<>();
		retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
		try {
			@SuppressWarnings("unused")
			Optional<DatasetAvailabilityType> datasetAvailability = getDatasetAvailability();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting datasetAvailability for DatasetPackage: "+e.getMessage());
		}
		try {
			@SuppressWarnings("unused")
			Optional<ConfidentialityLevelType> confidentialityLevel = getConfidentialityLevel();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting confidentialityLevel for DatasetPackage: "+e.getMessage());
		}
		try {
			@SuppressWarnings("unused")
			Optional<PresenceType> hasSensitivePersonalInformation = getHasSensitivePersonalInformation();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting hasSensitivePersonalInformation for DatasetPackage: "+e.getMessage());
		}
		try {
			Optional<Integer> datasetSize = getDatasetSize();
			if (datasetSize.isPresent() && datasetSize.get() < 0) {
				retval.add("datasetSize value " + datasetSize.get() + " is less than the minimum 0 in DatasetPackage");
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting datasetSize for DatasetPackage: "+e.getMessage());
		}
		try {
			@SuppressWarnings("unused")
			Optional<String> datasetNoise = getDatasetNoise();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting datasetNoise for DatasetPackage: "+e.getMessage());
		}
		try {
			@SuppressWarnings("unused")
			Optional<String> intendedUse = getIntendedUse();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting intendedUse for DatasetPackage: "+e.getMessage());
		}
		try {
			@SuppressWarnings("unused")
			Optional<String> dataCollectionProcess = getDataCollectionProcess();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting dataCollectionProcess for DatasetPackage: "+e.getMessage());
		}
		try {
			@SuppressWarnings("unused")
			Optional<String> datasetUpdateMechanism = getDatasetUpdateMechanism();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting datasetUpdateMechanism for DatasetPackage: "+e.getMessage());
		}
		for (DictionaryEntry sensor:sensors) {
			retval.addAll(sensor.verify(verifiedIds, specVersionForVerify, profiles));
		}
		return retval;
	}
	
	
	
	public static class DatasetPackageBuilder extends SpdxPackageBuilder {
	
		/**
		 * Create an DatasetPackageBuilder from another model object copying the modelStore and copyManager and using an anonymous ID
		 * @param from model object to copy the model store and copyManager from
		 * @throws InvalidSPDXAnalysisException
		 */
		public DatasetPackageBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
			this(from, from.getModelStore().getNextId(IdType.Anonymous));
		}
	
		/**
		 * Create an DatasetPackageBuilder from another model object copying the modelStore and copyManager
		 * @param from model object to copy the model store and copyManager from
		 * @param objectUri URI for the object
		 * @throws InvalidSPDXAnalysisException if creationInfo can not be fetched from the from
		 */
		public DatasetPackageBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
			this(from.getModelStore(), objectUri, from.getCopyManager());
			setStrict(from.isStrict());
			setIdPrefix(from.getIdPrefix());
			if (from instanceof Element) {
				setCreationInfo(((Element)from).getCreationInfo());
			} else if (from instanceof CreationInfo) {
				setCreationInfo((CreationInfo)from);
			}
		}
		
		/**
		 * Creates a DatasetPackageBuilder
		 * @param modelStore model store for the built DatasetPackage
		 * @param objectUri objectUri for the built DatasetPackage
		 * @param copyManager optional copyManager for the built DatasetPackage
		 */
		public DatasetPackageBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
			super(modelStore, objectUri, copyManager);
		}
		
		protected Collection<DictionaryEntry> sensors = new ArrayList<>();
		protected Collection<DatasetType> datasetTypes = new ArrayList<>();
		protected Collection<String> anonymizationMethodUseds = new ArrayList<>();
		protected Collection<String> knownBiass = new ArrayList<>();
		protected Collection<String> dataPreprocessings = new ArrayList<>();
		protected DatasetAvailabilityType datasetAvailability = null;
		protected ConfidentialityLevelType confidentialityLevel = null;
		protected PresenceType hasSensitivePersonalInformation = null;
		protected Integer datasetSize = null;
		protected String datasetNoise = null;
		protected String intendedUse = null;
		protected String dataCollectionProcess = null;
		protected String datasetUpdateMechanism = null;
		
		
		/**
		 * Adds a contentIdentifier to the initial collection
		 * @parameter contentIdentifier contentIdentifier to add
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addContentIdentifier(ContentIdentifier contentIdentifier) {
			if (Objects.nonNull(contentIdentifier)) {
				super.contentIdentifiers.add(contentIdentifier);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial contentIdentifier collection
		 * @parameter contentIdentifierCollection collection to initialize the contentIdentifier
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addAllContentIdentifier(Collection<ContentIdentifier> contentIdentifierCollection) {
			if (Objects.nonNull(contentIdentifierCollection)) {
				super.contentIdentifiers.addAll(contentIdentifierCollection);
			}
			return this;
		}
		
		/**
		 * Adds a verifiedUsing to the initial collection
		 * @parameter verifiedUsing verifiedUsing to add
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
			if (Objects.nonNull(verifiedUsing)) {
				super.verifiedUsings.add(verifiedUsing);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial verifiedUsing collection
		 * @parameter verifiedUsingCollection collection to initialize the verifiedUsing
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
			if (Objects.nonNull(verifiedUsingCollection)) {
				super.verifiedUsings.addAll(verifiedUsingCollection);
			}
			return this;
		}
		
		/**
		 * Adds a externalRef to the initial collection
		 * @parameter externalRef externalRef to add
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addExternalRef(ExternalRef externalRef) {
			if (Objects.nonNull(externalRef)) {
				super.externalRefs.add(externalRef);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial externalRef collection
		 * @parameter externalRefCollection collection to initialize the externalRef
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
			if (Objects.nonNull(externalRefCollection)) {
				super.externalRefs.addAll(externalRefCollection);
			}
			return this;
		}
		
		/**
		 * Adds a sensor to the initial collection
		 * @parameter sensor sensor to add
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addSensor(DictionaryEntry sensor) {
			if (Objects.nonNull(sensor)) {
				sensors.add(sensor);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial sensor collection
		 * @parameter sensorCollection collection to initialize the sensor
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addAllSensor(Collection<DictionaryEntry> sensorCollection) {
			if (Objects.nonNull(sensorCollection)) {
				sensors.addAll(sensorCollection);
			}
			return this;
		}
		
		/**
		 * Adds a externalIdentifier to the initial collection
		 * @parameter externalIdentifier externalIdentifier to add
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
			if (Objects.nonNull(externalIdentifier)) {
				super.externalIdentifiers.add(externalIdentifier);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial externalIdentifier collection
		 * @parameter externalIdentifierCollection collection to initialize the externalIdentifier
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
			if (Objects.nonNull(externalIdentifierCollection)) {
				super.externalIdentifiers.addAll(externalIdentifierCollection);
			}
			return this;
		}
		
		/**
		 * Adds a extension to the initial collection
		 * @parameter extension extension to add
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addExtension(Extension extension) {
			if (Objects.nonNull(extension)) {
				super.extensions.add(extension);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial extension collection
		 * @parameter extensionCollection collection to initialize the extension
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addAllExtension(Collection<Extension> extensionCollection) {
			if (Objects.nonNull(extensionCollection)) {
				super.extensions.addAll(extensionCollection);
			}
			return this;
		}
		
		/**
		 * Adds a originatedBy to the initial collection
		 * @parameter originatedBy originatedBy to add
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addOriginatedBy(Agent originatedBy) {
			if (Objects.nonNull(originatedBy)) {
				super.originatedBys.add(originatedBy);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial originatedBy collection
		 * @parameter originatedByCollection collection to initialize the originatedBy
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addAllOriginatedBy(Collection<Agent> originatedByCollection) {
			if (Objects.nonNull(originatedByCollection)) {
				super.originatedBys.addAll(originatedByCollection);
			}
			return this;
		}
		
		/**
		 * Adds a supportLevel to the initial collection
		 * @parameter supportLevel supportLevel to add
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addSupportLevel(SupportType supportLevel) {
			if (Objects.nonNull(supportLevel)) {
				super.supportLevels.add(supportLevel);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial supportLevel collection
		 * @parameter supportLevelCollection collection to initialize the supportLevel
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addAllSupportLevel(Collection<SupportType> supportLevelCollection) {
			if (Objects.nonNull(supportLevelCollection)) {
				super.supportLevels.addAll(supportLevelCollection);
			}
			return this;
		}
		
		/**
		 * Adds a additionalPurpose to the initial collection
		 * @parameter additionalPurpose additionalPurpose to add
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addAdditionalPurpose(SoftwarePurpose additionalPurpose) {
			if (Objects.nonNull(additionalPurpose)) {
				super.additionalPurposes.add(additionalPurpose);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial additionalPurpose collection
		 * @parameter additionalPurposeCollection collection to initialize the additionalPurpose
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addAllAdditionalPurpose(Collection<SoftwarePurpose> additionalPurposeCollection) {
			if (Objects.nonNull(additionalPurposeCollection)) {
				super.additionalPurposes.addAll(additionalPurposeCollection);
			}
			return this;
		}
		
		/**
		 * Adds a datasetType to the initial collection
		 * @parameter datasetType datasetType to add
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addDatasetType(DatasetType datasetType) {
			if (Objects.nonNull(datasetType)) {
				datasetTypes.add(datasetType);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial datasetType collection
		 * @parameter datasetTypeCollection collection to initialize the datasetType
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addAllDatasetType(Collection<DatasetType> datasetTypeCollection) {
			if (Objects.nonNull(datasetTypeCollection)) {
				datasetTypes.addAll(datasetTypeCollection);
			}
			return this;
		}
		
		/**
		 * Adds a attributionText to the initial collection
		 * @parameter attributionText attributionText to add
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addAttributionText(String attributionText) {
			if (Objects.nonNull(attributionText)) {
				super.attributionTexts.add(attributionText);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial attributionText collection
		 * @parameter attributionTextCollection collection to initialize the attributionText
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addAllAttributionText(Collection<String> attributionTextCollection) {
			if (Objects.nonNull(attributionTextCollection)) {
				super.attributionTexts.addAll(attributionTextCollection);
			}
			return this;
		}
		
		/**
		 * Adds a standardName to the initial collection
		 * @parameter standardName standardName to add
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addStandardName(String standardName) {
			if (Objects.nonNull(standardName)) {
				super.standardNames.add(standardName);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial standardName collection
		 * @parameter standardNameCollection collection to initialize the standardName
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addAllStandardName(Collection<String> standardNameCollection) {
			if (Objects.nonNull(standardNameCollection)) {
				super.standardNames.addAll(standardNameCollection);
			}
			return this;
		}
		
		/**
		 * Adds a anonymizationMethodUsed to the initial collection
		 * @parameter anonymizationMethodUsed anonymizationMethodUsed to add
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addAnonymizationMethodUsed(String anonymizationMethodUsed) {
			if (Objects.nonNull(anonymizationMethodUsed)) {
				anonymizationMethodUseds.add(anonymizationMethodUsed);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial anonymizationMethodUsed collection
		 * @parameter anonymizationMethodUsedCollection collection to initialize the anonymizationMethodUsed
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addAllAnonymizationMethodUsed(Collection<String> anonymizationMethodUsedCollection) {
			if (Objects.nonNull(anonymizationMethodUsedCollection)) {
				anonymizationMethodUseds.addAll(anonymizationMethodUsedCollection);
			}
			return this;
		}
		
		/**
		 * Adds a knownBias to the initial collection
		 * @parameter knownBias knownBias to add
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addKnownBias(String knownBias) {
			if (Objects.nonNull(knownBias)) {
				knownBiass.add(knownBias);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial knownBias collection
		 * @parameter knownBiasCollection collection to initialize the knownBias
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addAllKnownBias(Collection<String> knownBiasCollection) {
			if (Objects.nonNull(knownBiasCollection)) {
				knownBiass.addAll(knownBiasCollection);
			}
			return this;
		}
		
		/**
		 * Adds a dataPreprocessing to the initial collection
		 * @parameter dataPreprocessing dataPreprocessing to add
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addDataPreprocessing(String dataPreprocessing) {
			if (Objects.nonNull(dataPreprocessing)) {
				dataPreprocessings.add(dataPreprocessing);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial dataPreprocessing collection
		 * @parameter dataPreprocessingCollection collection to initialize the dataPreprocessing
		 * @return this for chaining
		**/
		public DatasetPackageBuilder addAllDataPreprocessing(Collection<String> dataPreprocessingCollection) {
			if (Objects.nonNull(dataPreprocessingCollection)) {
				dataPreprocessings.addAll(dataPreprocessingCollection);
			}
			return this;
		}
		
		/**
		 * Sets the initial value of creationInfo
		 * @parameter creationInfo value to set
		 * @return this for chaining
		**/
		public DatasetPackageBuilder setCreationInfo(CreationInfo creationInfo) {
			super.creationInfo = creationInfo;
			return this;
		}
		
		/**
		 * Sets the initial value of suppliedBy
		 * @parameter suppliedBy value to set
		 * @return this for chaining
		**/
		public DatasetPackageBuilder setSuppliedBy(Agent suppliedBy) {
			super.suppliedBy = suppliedBy;
			return this;
		}
		
		/**
		 * Sets the initial value of datasetAvailability
		 * @parameter datasetAvailability value to set
		 * @return this for chaining
		**/
		public DatasetPackageBuilder setDatasetAvailability(DatasetAvailabilityType datasetAvailability) {
			this.datasetAvailability = datasetAvailability;
			return this;
		}
		
		/**
		 * Sets the initial value of confidentialityLevel
		 * @parameter confidentialityLevel value to set
		 * @return this for chaining
		**/
		public DatasetPackageBuilder setConfidentialityLevel(ConfidentialityLevelType confidentialityLevel) {
			this.confidentialityLevel = confidentialityLevel;
			return this;
		}
		
		/**
		 * Sets the initial value of hasSensitivePersonalInformation
		 * @parameter hasSensitivePersonalInformation value to set
		 * @return this for chaining
		**/
		public DatasetPackageBuilder setHasSensitivePersonalInformation(PresenceType hasSensitivePersonalInformation) {
			this.hasSensitivePersonalInformation = hasSensitivePersonalInformation;
			return this;
		}
		
		/**
		 * Sets the initial value of primaryPurpose
		 * @parameter primaryPurpose value to set
		 * @return this for chaining
		**/
		public DatasetPackageBuilder setPrimaryPurpose(SoftwarePurpose primaryPurpose) {
			super.primaryPurpose = primaryPurpose;
			return this;
		}
		
		/**
		 * Sets the initial value of datasetSize
		 * @parameter datasetSize value to set
		 * @return this for chaining
		**/
		public DatasetPackageBuilder setDatasetSize(Integer datasetSize) {
			this.datasetSize = datasetSize;
			return this;
		}
		
		/**
		 * Sets the initial value of validUntilTime
		 * @parameter validUntilTime value to set
		 * @return this for chaining
		**/
		public DatasetPackageBuilder setValidUntilTime(String validUntilTime) {
			super.validUntilTime = validUntilTime;
			return this;
		}
		
		/**
		 * Sets the initial value of downloadLocation
		 * @parameter downloadLocation value to set
		 * @return this for chaining
		**/
		public DatasetPackageBuilder setDownloadLocation(String downloadLocation) {
			super.downloadLocation = downloadLocation;
			return this;
		}
		
		/**
		 * Sets the initial value of builtTime
		 * @parameter builtTime value to set
		 * @return this for chaining
		**/
		public DatasetPackageBuilder setBuiltTime(String builtTime) {
			super.builtTime = builtTime;
			return this;
		}
		
		/**
		 * Sets the initial value of datasetNoise
		 * @parameter datasetNoise value to set
		 * @return this for chaining
		**/
		public DatasetPackageBuilder setDatasetNoise(String datasetNoise) {
			this.datasetNoise = datasetNoise;
			return this;
		}
		
		/**
		 * Sets the initial value of summary
		 * @parameter summary value to set
		 * @return this for chaining
		**/
		public DatasetPackageBuilder setSummary(String summary) {
			super.summary = summary;
			return this;
		}
		
		/**
		 * Sets the initial value of packageVersion
		 * @parameter packageVersion value to set
		 * @return this for chaining
		**/
		public DatasetPackageBuilder setPackageVersion(String packageVersion) {
			super.packageVersion = packageVersion;
			return this;
		}
		
		/**
		 * Sets the initial value of releaseTime
		 * @parameter releaseTime value to set
		 * @return this for chaining
		**/
		public DatasetPackageBuilder setReleaseTime(String releaseTime) {
			super.releaseTime = releaseTime;
			return this;
		}
		
		/**
		 * Sets the initial value of copyrightText
		 * @parameter copyrightText value to set
		 * @return this for chaining
		**/
		public DatasetPackageBuilder setCopyrightText(String copyrightText) {
			super.copyrightText = copyrightText;
			return this;
		}
		
		/**
		 * Sets the initial value of comment
		 * @parameter comment value to set
		 * @return this for chaining
		**/
		public DatasetPackageBuilder setComment(String comment) {
			super.comment = comment;
			return this;
		}
		
		/**
		 * Sets the initial value of homePage
		 * @parameter homePage value to set
		 * @return this for chaining
		**/
		public DatasetPackageBuilder setHomePage(String homePage) {
			super.homePage = homePage;
			return this;
		}
		
		/**
		 * Sets the initial value of sourceInfo
		 * @parameter sourceInfo value to set
		 * @return this for chaining
		**/
		public DatasetPackageBuilder setSourceInfo(String sourceInfo) {
			super.sourceInfo = sourceInfo;
			return this;
		}
		
		/**
		 * Sets the initial value of intendedUse
		 * @parameter intendedUse value to set
		 * @return this for chaining
		**/
		public DatasetPackageBuilder setIntendedUse(String intendedUse) {
			this.intendedUse = intendedUse;
			return this;
		}
		
		/**
		 * Sets the initial value of description
		 * @parameter description value to set
		 * @return this for chaining
		**/
		public DatasetPackageBuilder setDescription(String description) {
			super.description = description;
			return this;
		}
		
		/**
		 * Sets the initial value of dataCollectionProcess
		 * @parameter dataCollectionProcess value to set
		 * @return this for chaining
		**/
		public DatasetPackageBuilder setDataCollectionProcess(String dataCollectionProcess) {
			this.dataCollectionProcess = dataCollectionProcess;
			return this;
		}
		
		/**
		 * Sets the initial value of datasetUpdateMechanism
		 * @parameter datasetUpdateMechanism value to set
		 * @return this for chaining
		**/
		public DatasetPackageBuilder setDatasetUpdateMechanism(String datasetUpdateMechanism) {
			this.datasetUpdateMechanism = datasetUpdateMechanism;
			return this;
		}
		
		/**
		 * Sets the initial value of name
		 * @parameter name value to set
		 * @return this for chaining
		**/
		public DatasetPackageBuilder setName(String name) {
			super.name = name;
			return this;
		}
		
		/**
		 * Sets the initial value of packageUrl
		 * @parameter packageUrl value to set
		 * @return this for chaining
		**/
		public DatasetPackageBuilder setPackageUrl(String packageUrl) {
			super.packageUrl = packageUrl;
			return this;
		}
	
		/**
		 * @return the DatasetPackage
		 * @throws InvalidSPDXAnalysisException on any errors during build
		 */
		public DatasetPackage build() throws InvalidSPDXAnalysisException {
			IModelStoreLock lock = getModelStore().enterCriticalSection(false);
			try {
				return new DatasetPackage(this);
			} finally {
				getModelStore().leaveCriticalSection(lock);
			}
		}
	}
}
