/**
 * Copyright (c) 2024 Source Auditor Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 * 
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
 
package org.spdx.library.model.v3_0_1.core;

import javax.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.storage.IModelStore;
import org.spdx.storage.IModelStore.IdType;
import org.spdx.storage.IModelStore.IModelStoreLock;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;

/**
 * DO NOT EDIT - this file is generated by the Owl to Java Utility 
 * See: https://github.com/spdx/tools-java 
 * 
 * An SPDX version 2.X compatible verification method for software packages. 
 */
public  class PackageVerificationCode extends IntegrityMethod  {

	Collection<String> packageVerificationCodeExcludedFiles = Collections.emptyList();
	
	/**
	 * Create the PackageVerificationCode with default model store and generated anonymous ID
	 * @throws InvalidSPDXAnalysisException when unable to create the PackageVerificationCode
	 */
	public PackageVerificationCode() throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore().getNextId(IdType.Anonymous));
	}

	/**
	 * @param objectUri URI or anonymous ID for the PackageVerificationCode
	 * @throws InvalidSPDXAnalysisException when unable to create the PackageVerificationCode
	 */
	public PackageVerificationCode(String objectUri) throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), 
				true, DefaultModelStore.getDefaultDocumentUri() + "#");
	}

	/**
	 * @param modelStore Model store where the PackageVerificationCode is to be stored
	 * @param objectUri URI or anonymous ID for the PackageVerificationCode
	 * @param copyManager Copy manager for the PackageVerificationCode - can be null if copying is not required
	 * @param create true if PackageVerificationCode is to be created
	 * @param idPrefix - prefix to be used when generating new SPDX IDs
	 * @throws InvalidSPDXAnalysisException when unable to create the PackageVerificationCode
	 */
	 @SuppressWarnings("unchecked")
	public PackageVerificationCode(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager,
			boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
		super(modelStore, objectUri, copyManager, create, idPrefix);
		if (!isExternal()) {
			packageVerificationCodeExcludedFiles = (Collection<String>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_PACKAGE_VERIFICATION_CODE_EXCLUDED_FILE, String.class);
		}
	}

	/**
	 * Create the PackageVerificationCode from the builder - used in the builder class
	 * @param builder Builder to create the PackageVerificationCode from
	 * @throws InvalidSPDXAnalysisException when unable to create the PackageVerificationCode
	 */
	 @SuppressWarnings("unchecked")
	protected PackageVerificationCode(PackageVerificationCodeBuilder builder) throws InvalidSPDXAnalysisException {
		super(builder);
		packageVerificationCodeExcludedFiles = (Collection<String>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_PACKAGE_VERIFICATION_CODE_EXCLUDED_FILE, String.class);
		getPackageVerificationCodeExcludedFiles().addAll(builder.packageVerificationCodeExcludedFiles);
		if (Objects.nonNull(builder.algorithm)) {
			setAlgorithm(builder.algorithm);
		}
		if (Objects.nonNull(builder.hashValue)) {
			setHashValue(builder.hashValue);
		}
	}

	/* (non-Javadoc)
	 * @see org.spdx.library.core.CoreModelObject#getType()
	 */
	@Override
	public String getType() {
		return "Core.PackageVerificationCode";
	}
	
	// Getters and Setters
	public Collection<String> getPackageVerificationCodeExcludedFiles() {
		return packageVerificationCodeExcludedFiles;
	}
	
	/**
	 * @return the algorithm
	 */
	public @Nullable HashAlgorithm getAlgorithm() throws InvalidSPDXAnalysisException {
		Optional<Enum<?>> retval = getEnumPropertyValue(SpdxConstantsV3.PROP_ALGORITHM);
		if (retval.isPresent()) {
			if (!(retval.get() instanceof HashAlgorithm)) {
				throw new InvalidSPDXAnalysisException("Incorrect type stored for algorithm");
			}
			return (HashAlgorithm)(retval.get());
		} else {
			return null;
		}
	}
	/**
	 * @param algorithm the algorithm to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public PackageVerificationCode setAlgorithm(@Nullable HashAlgorithm algorithm) throws InvalidSPDXAnalysisException {
		if (isStrict() && Objects.isNull(algorithm)) {
			throw new InvalidSPDXAnalysisException("algorithm is a required property");
		}
		setPropertyValue(SpdxConstantsV3.PROP_ALGORITHM, algorithm);
		return this;
	}
	/**
	 * @return the hashValue
	 */
	public @Nullable String getHashValue() throws InvalidSPDXAnalysisException {
		Optional<String> retval = getStringPropertyValue(SpdxConstantsV3.PROP_HASH_VALUE);
		return retval.isPresent() ? retval.get() : null;
	}
		/**
	 * @param hashValue the hashValue to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public PackageVerificationCode setHashValue(@Nullable String hashValue) throws InvalidSPDXAnalysisException {
		if (isStrict() && Objects.isNull(hashValue)) {
			throw new InvalidSPDXAnalysisException("hashValue is a required property");
		}
		setPropertyValue(SpdxConstantsV3.PROP_HASH_VALUE, hashValue);
		return this;
	}
	/**
	 * @param comment the comment to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public PackageVerificationCode setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
		super.setComment(comment);
		return this;
	}	
	
	
	@Override
	public String toString() {
		return "PackageVerificationCode: "+getObjectUri();
		
	}
	
	/* (non-Javadoc)
	 * @see org.spdx.library.model.v3.ModelObjectV3#_verify(java.util.List)
	 */
	@Override
	public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
		List<String> retval = new ArrayList<>();
		retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
		try {
			HashAlgorithm algorithm = getAlgorithm();
			if (Objects.isNull(algorithm) && 
						Collections.disjoint(profiles, Arrays.asList(new ProfileIdentifierType[] { ProfileIdentifierType.CORE }))) {
				retval.add("Missing algorithm in PackageVerificationCode");
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting algorithm for PackageVerificationCode: "+e.getMessage());
		}
		try {
			String hashValue = getHashValue();
			if (Objects.isNull(hashValue) &&
					Collections.disjoint(profiles, Arrays.asList(new ProfileIdentifierType[] { ProfileIdentifierType.CORE }))) {
				retval.add("Missing hashValue in PackageVerificationCode");
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting hashValue for PackageVerificationCode: "+e.getMessage());
		}
		return retval;
	}
	
	
	
	public static class PackageVerificationCodeBuilder extends IntegrityMethodBuilder {
	
		/**
		 * Create an PackageVerificationCodeBuilder from another model object copying the modelStore and copyManager and using an anonymous ID
		 * @param from model object to copy the model store and copyManager from
		 * @throws InvalidSPDXAnalysisException
		 */
		public PackageVerificationCodeBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
			this(from, from.getModelStore().getNextId(IdType.Anonymous));
		}
	
		/**
		 * Create an PackageVerificationCodeBuilder from another model object copying the modelStore and copyManager
		 * @param from model object to copy the model store and copyManager from
		 * @param objectUri URI for the object
		 * @throws InvalidSPDXAnalysisException if creationInfo can not be fetched from the from
		 */
		public PackageVerificationCodeBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
			this(from.getModelStore(), objectUri, from.getCopyManager());
			setStrict(from.isStrict());
			setIdPrefix(from.getIdPrefix());
		}
		
		/**
		 * Creates a PackageVerificationCodeBuilder
		 * @param modelStore model store for the built PackageVerificationCode
		 * @param objectUri objectUri for the built PackageVerificationCode
		 * @param copyManager optional copyManager for the built PackageVerificationCode
		 */
		public PackageVerificationCodeBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
			super(modelStore, objectUri, copyManager);
		}
		
		protected Collection<String> packageVerificationCodeExcludedFiles = new ArrayList<>();
		protected HashAlgorithm algorithm = null;
		protected String hashValue = null;
		
		
		/**
		 * Adds a packageVerificationCodeExcludedFile to the initial collection
		 * @parameter packageVerificationCodeExcludedFile packageVerificationCodeExcludedFile to add
		 * @return this for chaining
		**/
		public PackageVerificationCodeBuilder addPackageVerificationCodeExcludedFile(String packageVerificationCodeExcludedFile) {
			if (Objects.nonNull(packageVerificationCodeExcludedFile)) {
				packageVerificationCodeExcludedFiles.add(packageVerificationCodeExcludedFile);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial packageVerificationCodeExcludedFile collection
		 * @parameter packageVerificationCodeExcludedFileCollection collection to initialize the packageVerificationCodeExcludedFile
		 * @return this for chaining
		**/
		public PackageVerificationCodeBuilder addAllPackageVerificationCodeExcludedFile(Collection<String> packageVerificationCodeExcludedFileCollection) {
			if (Objects.nonNull(packageVerificationCodeExcludedFileCollection)) {
				packageVerificationCodeExcludedFiles.addAll(packageVerificationCodeExcludedFileCollection);
			}
			return this;
		}
		
		/**
		 * Sets the initial value of algorithm
		 * @parameter algorithm value to set
		 * @return this for chaining
		**/
		public PackageVerificationCodeBuilder setAlgorithm(HashAlgorithm algorithm) {
			this.algorithm = algorithm;
			return this;
		}
		
		/**
		 * Sets the initial value of hashValue
		 * @parameter hashValue value to set
		 * @return this for chaining
		**/
		public PackageVerificationCodeBuilder setHashValue(String hashValue) {
			this.hashValue = hashValue;
			return this;
		}
		
		/**
		 * Sets the initial value of comment
		 * @parameter comment value to set
		 * @return this for chaining
		**/
		public PackageVerificationCodeBuilder setComment(String comment) {
			super.comment = comment;
			return this;
		}
	
		/**
		 * @return the PackageVerificationCode
		 * @throws InvalidSPDXAnalysisException on any errors during build
		 */
		public PackageVerificationCode build() throws InvalidSPDXAnalysisException {
			IModelStoreLock lock = getModelStore().enterCriticalSection(false);
			try {
				return new PackageVerificationCode(this);
			} finally {
				getModelStore().leaveCriticalSection(lock);
			}
		}
	}
}
