/**
 * Copyright (c) 2024 Source Auditor Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 * 
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
 
package org.spdx.library.model.v3_0_1.core;

import javax.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.storage.IModelStore;
import org.spdx.storage.IModelStore.IdType;
import org.spdx.storage.IModelStore.IModelStoreLock;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;

/**
 * DO NOT EDIT - this file is generated by the Owl to Java Utility 
 * See: https://github.com/spdx/tools-java 
 * 
 * A reference to a resource identifier defined outside the scope of SPDX-3.0 content 
 * that uniquely identifies an Element. 
 */
public  class ExternalIdentifier extends ModelObjectV3  {

	Collection<String> identifierLocators = Collections.emptyList();
	
	/**
	 * Create the ExternalIdentifier with default model store and generated anonymous ID
	 * @throws InvalidSPDXAnalysisException when unable to create the ExternalIdentifier
	 */
	public ExternalIdentifier() throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore().getNextId(IdType.Anonymous));
	}

	/**
	 * @param objectUri URI or anonymous ID for the ExternalIdentifier
	 * @throws InvalidSPDXAnalysisException when unable to create the ExternalIdentifier
	 */
	public ExternalIdentifier(String objectUri) throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), 
				true, DefaultModelStore.getDefaultDocumentUri() + "#");
	}

	/**
	 * @param modelStore Model store where the ExternalIdentifier is to be stored
	 * @param objectUri URI or anonymous ID for the ExternalIdentifier
	 * @param copyManager Copy manager for the ExternalIdentifier - can be null if copying is not required
	 * @param create true if ExternalIdentifier is to be created
	 * @param idPrefix - prefix to be used when generating new SPDX IDs
	 * @throws InvalidSPDXAnalysisException when unable to create the ExternalIdentifier
	 */
	 @SuppressWarnings("unchecked")
	public ExternalIdentifier(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager,
			boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
		super(modelStore, objectUri, copyManager, create, idPrefix);
		if (!isExternal()) {
			identifierLocators = (Collection<String>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_IDENTIFIER_LOCATOR, String.class);
		}
	}

	/**
	 * Create the ExternalIdentifier from the builder - used in the builder class
	 * @param builder Builder to create the ExternalIdentifier from
	 * @throws InvalidSPDXAnalysisException when unable to create the ExternalIdentifier
	 */
	 @SuppressWarnings("unchecked")
	protected ExternalIdentifier(ExternalIdentifierBuilder builder) throws InvalidSPDXAnalysisException {
		super(builder);
		identifierLocators = (Collection<String>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_IDENTIFIER_LOCATOR, String.class);
		getIdentifierLocators().addAll(builder.identifierLocators);
		if (Objects.nonNull(builder.externalIdentifierType)) {
			setExternalIdentifierType(builder.externalIdentifierType);
		}
		if (Objects.nonNull(builder.identifier)) {
			setIdentifier(builder.identifier);
		}
		setComment(builder.comment);
		setIssuingAuthority(builder.issuingAuthority);
	}

	/* (non-Javadoc)
	 * @see org.spdx.library.core.CoreModelObject#getType()
	 */
	@Override
	public String getType() {
		return "Core.ExternalIdentifier";
	}
	
	// Getters and Setters
	public Collection<String> getIdentifierLocators() {
		return identifierLocators;
	}
	
	/**
	 * @return the externalIdentifierType
	 */
	public @Nullable ExternalIdentifierType getExternalIdentifierType() throws InvalidSPDXAnalysisException {
		Optional<Enum<?>> retval = getEnumPropertyValue(SpdxConstantsV3.PROP_EXTERNAL_IDENTIFIER_TYPE);
		if (retval.isPresent()) {
			if (!(retval.get() instanceof ExternalIdentifierType)) {
				throw new InvalidSPDXAnalysisException("Incorrect type stored for externalIdentifierType");
			}
			return (ExternalIdentifierType)(retval.get());
		} else {
			return null;
		}
	}
	/**
	 * @param externalIdentifierType the externalIdentifierType to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public ExternalIdentifier setExternalIdentifierType(@Nullable ExternalIdentifierType externalIdentifierType) throws InvalidSPDXAnalysisException {
		if (isStrict() && Objects.isNull(externalIdentifierType)) {
			throw new InvalidSPDXAnalysisException("externalIdentifierType is a required property");
		}
		setPropertyValue(SpdxConstantsV3.PROP_EXTERNAL_IDENTIFIER_TYPE, externalIdentifierType);
		return this;
	}
	/**
	 * @return the identifier
	 */
	public @Nullable String getIdentifier() throws InvalidSPDXAnalysisException {
		Optional<String> retval = getStringPropertyValue(SpdxConstantsV3.PROP_IDENTIFIER);
		return retval.isPresent() ? retval.get() : null;
	}
		/**
	 * @param identifier the identifier to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public ExternalIdentifier setIdentifier(@Nullable String identifier) throws InvalidSPDXAnalysisException {
		if (isStrict() && Objects.isNull(identifier)) {
			throw new InvalidSPDXAnalysisException("identifier is a required property");
		}
		setPropertyValue(SpdxConstantsV3.PROP_IDENTIFIER, identifier);
		return this;
	}
		/**
	 * @return the comment
	 */
	public Optional<String> getComment() throws InvalidSPDXAnalysisException {
		return getStringPropertyValue(SpdxConstantsV3.PROP_COMMENT);
	}
	/**
	 * @param comment the comment to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public ExternalIdentifier setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_COMMENT, comment);
		return this;
	}
		/**
	 * @return the issuingAuthority
	 */
	public Optional<String> getIssuingAuthority() throws InvalidSPDXAnalysisException {
		return getStringPropertyValue(SpdxConstantsV3.PROP_ISSUING_AUTHORITY);
	}
	/**
	 * @param issuingAuthority the issuingAuthority to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public ExternalIdentifier setIssuingAuthority(@Nullable String issuingAuthority) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_ISSUING_AUTHORITY, issuingAuthority);
		return this;
	}
	
	
	@Override
	public String toString() {
		return "ExternalIdentifier: "+getObjectUri();
		
	}
	
	/* (non-Javadoc)
	 * @see org.spdx.library.model.v3.ModelObjectV3#_verify(java.util.List)
	 */
	@Override
	public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
		List<String> retval = new ArrayList<>();
		try {
			ExternalIdentifierType externalIdentifierType = getExternalIdentifierType();
			if (Objects.isNull(externalIdentifierType) && 
						Collections.disjoint(profiles, Arrays.asList(new ProfileIdentifierType[] { ProfileIdentifierType.CORE }))) {
				retval.add("Missing externalIdentifierType in ExternalIdentifier");
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting externalIdentifierType for ExternalIdentifier: "+e.getMessage());
		}
		try {
			String identifier = getIdentifier();
			if (Objects.isNull(identifier) &&
					Collections.disjoint(profiles, Arrays.asList(new ProfileIdentifierType[] { ProfileIdentifierType.CORE }))) {
				retval.add("Missing identifier in ExternalIdentifier");
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting identifier for ExternalIdentifier: "+e.getMessage());
		}
		try {
			@SuppressWarnings("unused")
			Optional<String> comment = getComment();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting comment for ExternalIdentifier: "+e.getMessage());
		}
		try {
			@SuppressWarnings("unused")
			Optional<String> issuingAuthority = getIssuingAuthority();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting issuingAuthority for ExternalIdentifier: "+e.getMessage());
		}
		return retval;
	}
	
	
	
	public static class ExternalIdentifierBuilder extends ModelObjectV3Builder {
	
		/**
		 * Create an ExternalIdentifierBuilder from another model object copying the modelStore and copyManager and using an anonymous ID
		 * @param from model object to copy the model store and copyManager from
		 * @throws InvalidSPDXAnalysisException
		 */
		public ExternalIdentifierBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
			this(from, from.getModelStore().getNextId(IdType.Anonymous));
		}
	
		/**
		 * Create an ExternalIdentifierBuilder from another model object copying the modelStore and copyManager
		 * @param from model object to copy the model store and copyManager from
		 * @param objectUri URI for the object
		 * @throws InvalidSPDXAnalysisException if creationInfo can not be fetched from the from
		 */
		public ExternalIdentifierBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
			this(from.getModelStore(), objectUri, from.getCopyManager());
			setStrict(from.isStrict());
			setIdPrefix(from.getIdPrefix());
		}
		
		/**
		 * Creates a ExternalIdentifierBuilder
		 * @param modelStore model store for the built ExternalIdentifier
		 * @param objectUri objectUri for the built ExternalIdentifier
		 * @param copyManager optional copyManager for the built ExternalIdentifier
		 */
		public ExternalIdentifierBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
			super(modelStore, objectUri, copyManager);
		}
		
		protected Collection<String> identifierLocators = new ArrayList<>();
		protected ExternalIdentifierType externalIdentifierType = null;
		protected String identifier = null;
		protected String comment = null;
		protected String issuingAuthority = null;
		
		
		/**
		 * Adds a identifierLocator to the initial collection
		 * @parameter identifierLocator identifierLocator to add
		 * @return this for chaining
		**/
		public ExternalIdentifierBuilder addIdentifierLocator(String identifierLocator) {
			if (Objects.nonNull(identifierLocator)) {
				identifierLocators.add(identifierLocator);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial identifierLocator collection
		 * @parameter identifierLocatorCollection collection to initialize the identifierLocator
		 * @return this for chaining
		**/
		public ExternalIdentifierBuilder addAllIdentifierLocator(Collection<String> identifierLocatorCollection) {
			if (Objects.nonNull(identifierLocatorCollection)) {
				identifierLocators.addAll(identifierLocatorCollection);
			}
			return this;
		}
		
		/**
		 * Sets the initial value of externalIdentifierType
		 * @parameter externalIdentifierType value to set
		 * @return this for chaining
		**/
		public ExternalIdentifierBuilder setExternalIdentifierType(ExternalIdentifierType externalIdentifierType) {
			this.externalIdentifierType = externalIdentifierType;
			return this;
		}
		
		/**
		 * Sets the initial value of identifier
		 * @parameter identifier value to set
		 * @return this for chaining
		**/
		public ExternalIdentifierBuilder setIdentifier(String identifier) {
			this.identifier = identifier;
			return this;
		}
		
		/**
		 * Sets the initial value of comment
		 * @parameter comment value to set
		 * @return this for chaining
		**/
		public ExternalIdentifierBuilder setComment(String comment) {
			this.comment = comment;
			return this;
		}
		
		/**
		 * Sets the initial value of issuingAuthority
		 * @parameter issuingAuthority value to set
		 * @return this for chaining
		**/
		public ExternalIdentifierBuilder setIssuingAuthority(String issuingAuthority) {
			this.issuingAuthority = issuingAuthority;
			return this;
		}
	
		/**
		 * @return the ExternalIdentifier
		 * @throws InvalidSPDXAnalysisException on any errors during build
		 */
		public ExternalIdentifier build() throws InvalidSPDXAnalysisException {
			IModelStoreLock lock = getModelStore().enterCriticalSection(false);
			try {
				return new ExternalIdentifier(this);
			} finally {
				getModelStore().leaveCriticalSection(lock);
			}
		}
	}
}
