/**
 * Copyright (c) 2024 Source Auditor Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 * 
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
 
package org.spdx.library.model.v3_0_1.core;

import javax.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.storage.IModelStore;
import org.spdx.storage.IModelStore.IdType;
import org.spdx.storage.IModelStore.IModelStoreLock;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.extension.Extension;

/**
 * DO NOT EDIT - this file is generated by the Owl to Java Utility 
 * See: https://github.com/spdx/tools-java 
 * 
 * An assertion made in relation to one or more elements. 
 */
public  class Annotation extends Element  {

	
	/**
	 * Create the Annotation with default model store and generated anonymous ID
	 * @throws InvalidSPDXAnalysisException when unable to create the Annotation
	 */
	public Annotation() throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore().getNextId(IdType.Anonymous));
	}

	/**
	 * @param objectUri URI or anonymous ID for the Annotation
	 * @throws InvalidSPDXAnalysisException when unable to create the Annotation
	 */
	public Annotation(String objectUri) throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), 
				true, DefaultModelStore.getDefaultDocumentUri() + "#");
	}

	/**
	 * @param modelStore Model store where the Annotation is to be stored
	 * @param objectUri URI or anonymous ID for the Annotation
	 * @param copyManager Copy manager for the Annotation - can be null if copying is not required
	 * @param create true if Annotation is to be created
	 * @param idPrefix - prefix to be used when generating new SPDX IDs
	 * @throws InvalidSPDXAnalysisException when unable to create the Annotation
	 */
	 @SuppressWarnings("unchecked")
	public Annotation(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager,
			boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
		super(modelStore, objectUri, copyManager, create, idPrefix);
	}

	/**
	 * Create the Annotation from the builder - used in the builder class
	 * @param builder Builder to create the Annotation from
	 * @throws InvalidSPDXAnalysisException when unable to create the Annotation
	 */
	 @SuppressWarnings("unchecked")
	protected Annotation(AnnotationBuilder builder) throws InvalidSPDXAnalysisException {
		super(builder);
		if (Objects.nonNull(builder.subject)) {
			setSubject(builder.subject);
		}
		if (Objects.nonNull(builder.annotationType)) {
			setAnnotationType(builder.annotationType);
		}
		setStatement(builder.statement);
		setContentType(builder.contentType);
	}

	/* (non-Javadoc)
	 * @see org.spdx.library.core.CoreModelObject#getType()
	 */
	@Override
	public String getType() {
		return "Core.Annotation";
	}
	
	// Getters and Setters
	
	/**
	 * @return the subject
	 */
	 @SuppressWarnings("unchecked")
	public @Nullable Element getSubject() throws InvalidSPDXAnalysisException {
		Optional<Object> retval = getObjectPropertyValue(SpdxConstantsV3.PROP_SUBJECT);
		if (retval.isPresent()) {
			if (!(retval.get() instanceof Element)) {
				throw new InvalidSPDXAnalysisException("Incorrect type stored for subject");
			}
			return (Element)(retval.get());
		} else {
			return null;
		}
	}
		
	/**
	 * @param subject the subject to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public Annotation setSubject(@Nullable Element subject) throws InvalidSPDXAnalysisException {
		if (isStrict() && Objects.isNull(subject)) {
			throw new InvalidSPDXAnalysisException("subject is a required property");
		}
		setPropertyValue(SpdxConstantsV3.PROP_SUBJECT, subject);
		return this;
	}
	/**
	 * @param creationInfo the creationInfo to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Annotation setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
		super.setCreationInfo(creationInfo);
		return this;
	}	
	/**
	 * @return the annotationType
	 */
	public @Nullable AnnotationType getAnnotationType() throws InvalidSPDXAnalysisException {
		Optional<Enum<?>> retval = getEnumPropertyValue(SpdxConstantsV3.PROP_ANNOTATION_TYPE);
		if (retval.isPresent()) {
			if (!(retval.get() instanceof AnnotationType)) {
				throw new InvalidSPDXAnalysisException("Incorrect type stored for annotationType");
			}
			return (AnnotationType)(retval.get());
		} else {
			return null;
		}
	}
	/**
	 * @param annotationType the annotationType to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public Annotation setAnnotationType(@Nullable AnnotationType annotationType) throws InvalidSPDXAnalysisException {
		if (isStrict() && Objects.isNull(annotationType)) {
			throw new InvalidSPDXAnalysisException("annotationType is a required property");
		}
		setPropertyValue(SpdxConstantsV3.PROP_ANNOTATION_TYPE, annotationType);
		return this;
	}
	/**
	 * @param summary the summary to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Annotation setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
		super.setSummary(summary);
		return this;
	}	
	/**
	 * @param description the description to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Annotation setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
		super.setDescription(description);
		return this;
	}	
		/**
	 * @return the statement
	 */
	public Optional<String> getStatement() throws InvalidSPDXAnalysisException {
		return getStringPropertyValue(SpdxConstantsV3.PROP_STATEMENT);
	}
	/**
	 * @param statement the statement to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public Annotation setStatement(@Nullable String statement) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_STATEMENT, statement);
		return this;
	}
		/**
	 * @return the contentType
	 */
	public Optional<String> getContentType() throws InvalidSPDXAnalysisException {
		return getStringPropertyValue(SpdxConstantsV3.PROP_CONTENT_TYPE);
	}
	/**
	 * @param contentType the contentType to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public Annotation setContentType(@Nullable String contentType) throws InvalidSPDXAnalysisException {
		if (isStrict() && Objects.nonNull(contentType) && !Pattern.matches("^[^\\/]+\\/[^\\/]+$", contentType)) {
			throw new InvalidSPDXAnalysisException("contentType value '" + contentType + 
				"' does not match the pattern '^[^\\/]+\\/[^\\/]+$'");
		}
		setPropertyValue(SpdxConstantsV3.PROP_CONTENT_TYPE, contentType);
		return this;
	}
	/**
	 * @param comment the comment to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Annotation setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
		super.setComment(comment);
		return this;
	}	
	/**
	 * @param name the name to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Annotation setName(@Nullable String name) throws InvalidSPDXAnalysisException {
		super.setName(name);
		return this;
	}	
	
	
	@Override
	public String toString() {
				return super.toString();
	}
	
	/* (non-Javadoc)
	 * @see org.spdx.library.model.v3.ModelObjectV3#_verify(java.util.List)
	 */
	@Override
	public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
		List<String> retval = new ArrayList<>();
		retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
		Element subject;
		try {
			subject = getSubject();
			if (Objects.nonNull(subject)) {
				retval.addAll(subject.verify(verifiedIds, specVersionForVerify, profiles));
			} else if (!Collections.disjoint(profiles, Arrays.asList(new ProfileIdentifierType[] { ProfileIdentifierType.CORE }))) {
					retval.add("Missing subject in Annotation");
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting subject for Annotation: "+e.getMessage());
		}
		try {
			AnnotationType annotationType = getAnnotationType();
			if (Objects.isNull(annotationType) && 
						Collections.disjoint(profiles, Arrays.asList(new ProfileIdentifierType[] { ProfileIdentifierType.CORE }))) {
				retval.add("Missing annotationType in Annotation");
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting annotationType for Annotation: "+e.getMessage());
		}
		try {
			@SuppressWarnings("unused")
			Optional<String> statement = getStatement();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting statement for Annotation: "+e.getMessage());
		}
		try {
			Optional<String> contentType = getContentType();
			if (contentType.isPresent() && !Pattern.matches("^[^\\/]+\\/[^\\/]+$", contentType.get())) {
				retval.add("contentType value '" + contentType.get() + 
					"' does not match the pattern '^[^\\/]+\\/[^\\/]+$'");
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting contentType for Annotation: "+e.getMessage());
		}
		return retval;
	}
	
	
	
	public static class AnnotationBuilder extends ElementBuilder {
	
		/**
		 * Create an AnnotationBuilder from another model object copying the modelStore and copyManager and using an anonymous ID
		 * @param from model object to copy the model store and copyManager from
		 * @throws InvalidSPDXAnalysisException
		 */
		public AnnotationBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
			this(from, from.getModelStore().getNextId(IdType.Anonymous));
		}
	
		/**
		 * Create an AnnotationBuilder from another model object copying the modelStore and copyManager
		 * @param from model object to copy the model store and copyManager from
		 * @param objectUri URI for the object
		 * @throws InvalidSPDXAnalysisException if creationInfo can not be fetched from the from
		 */
		public AnnotationBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
			this(from.getModelStore(), objectUri, from.getCopyManager());
			setStrict(from.isStrict());
			setIdPrefix(from.getIdPrefix());
			if (from instanceof Element) {
				setCreationInfo(((Element)from).getCreationInfo());
			} else if (from instanceof CreationInfo) {
				setCreationInfo((CreationInfo)from);
			}
		}
		
		/**
		 * Creates a AnnotationBuilder
		 * @param modelStore model store for the built Annotation
		 * @param objectUri objectUri for the built Annotation
		 * @param copyManager optional copyManager for the built Annotation
		 */
		public AnnotationBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
			super(modelStore, objectUri, copyManager);
		}
		
		protected Element subject = null;
		protected AnnotationType annotationType = null;
		protected String statement = null;
		protected String contentType = null;
		
		
		/**
		 * Adds a extension to the initial collection
		 * @parameter extension extension to add
		 * @return this for chaining
		**/
		public AnnotationBuilder addExtension(Extension extension) {
			if (Objects.nonNull(extension)) {
				super.extensions.add(extension);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial extension collection
		 * @parameter extensionCollection collection to initialize the extension
		 * @return this for chaining
		**/
		public AnnotationBuilder addAllExtension(Collection<Extension> extensionCollection) {
			if (Objects.nonNull(extensionCollection)) {
				super.extensions.addAll(extensionCollection);
			}
			return this;
		}
		
		/**
		 * Adds a verifiedUsing to the initial collection
		 * @parameter verifiedUsing verifiedUsing to add
		 * @return this for chaining
		**/
		public AnnotationBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
			if (Objects.nonNull(verifiedUsing)) {
				super.verifiedUsings.add(verifiedUsing);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial verifiedUsing collection
		 * @parameter verifiedUsingCollection collection to initialize the verifiedUsing
		 * @return this for chaining
		**/
		public AnnotationBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
			if (Objects.nonNull(verifiedUsingCollection)) {
				super.verifiedUsings.addAll(verifiedUsingCollection);
			}
			return this;
		}
		
		/**
		 * Adds a externalRef to the initial collection
		 * @parameter externalRef externalRef to add
		 * @return this for chaining
		**/
		public AnnotationBuilder addExternalRef(ExternalRef externalRef) {
			if (Objects.nonNull(externalRef)) {
				super.externalRefs.add(externalRef);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial externalRef collection
		 * @parameter externalRefCollection collection to initialize the externalRef
		 * @return this for chaining
		**/
		public AnnotationBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
			if (Objects.nonNull(externalRefCollection)) {
				super.externalRefs.addAll(externalRefCollection);
			}
			return this;
		}
		
		/**
		 * Adds a externalIdentifier to the initial collection
		 * @parameter externalIdentifier externalIdentifier to add
		 * @return this for chaining
		**/
		public AnnotationBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
			if (Objects.nonNull(externalIdentifier)) {
				super.externalIdentifiers.add(externalIdentifier);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial externalIdentifier collection
		 * @parameter externalIdentifierCollection collection to initialize the externalIdentifier
		 * @return this for chaining
		**/
		public AnnotationBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
			if (Objects.nonNull(externalIdentifierCollection)) {
				super.externalIdentifiers.addAll(externalIdentifierCollection);
			}
			return this;
		}
		
		/**
		 * Sets the initial value of subject
		 * @parameter subject value to set
		 * @return this for chaining
		**/
		public AnnotationBuilder setSubject(Element subject) {
			this.subject = subject;
			return this;
		}
		
		/**
		 * Sets the initial value of creationInfo
		 * @parameter creationInfo value to set
		 * @return this for chaining
		**/
		public AnnotationBuilder setCreationInfo(CreationInfo creationInfo) {
			super.creationInfo = creationInfo;
			return this;
		}
		
		/**
		 * Sets the initial value of annotationType
		 * @parameter annotationType value to set
		 * @return this for chaining
		**/
		public AnnotationBuilder setAnnotationType(AnnotationType annotationType) {
			this.annotationType = annotationType;
			return this;
		}
		
		/**
		 * Sets the initial value of summary
		 * @parameter summary value to set
		 * @return this for chaining
		**/
		public AnnotationBuilder setSummary(String summary) {
			super.summary = summary;
			return this;
		}
		
		/**
		 * Sets the initial value of description
		 * @parameter description value to set
		 * @return this for chaining
		**/
		public AnnotationBuilder setDescription(String description) {
			super.description = description;
			return this;
		}
		
		/**
		 * Sets the initial value of statement
		 * @parameter statement value to set
		 * @return this for chaining
		**/
		public AnnotationBuilder setStatement(String statement) {
			this.statement = statement;
			return this;
		}
		
		/**
		 * Sets the initial value of contentType
		 * @parameter contentType value to set
		 * @return this for chaining
		**/
		public AnnotationBuilder setContentType(String contentType) {
			this.contentType = contentType;
			return this;
		}
		
		/**
		 * Sets the initial value of comment
		 * @parameter comment value to set
		 * @return this for chaining
		**/
		public AnnotationBuilder setComment(String comment) {
			super.comment = comment;
			return this;
		}
		
		/**
		 * Sets the initial value of name
		 * @parameter name value to set
		 * @return this for chaining
		**/
		public AnnotationBuilder setName(String name) {
			super.name = name;
			return this;
		}
	
		/**
		 * @return the Annotation
		 * @throws InvalidSPDXAnalysisException on any errors during build
		 */
		public Annotation build() throws InvalidSPDXAnalysisException {
			IModelStoreLock lock = getModelStore().enterCriticalSection(false);
			try {
				return new Annotation(this);
			} finally {
				getModelStore().leaveCriticalSection(lock);
			}
		}
	}
}
