/**
 * Copyright (c) 2024 Source Auditor Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 * 
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
 
package org.spdx.library.model.v3_0_1.ai;

import javax.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.storage.IModelStore;
import org.spdx.storage.IModelStore.IdType;
import org.spdx.storage.IModelStore.IModelStoreLock;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;

/**
 * DO NOT EDIT - this file is generated by the Owl to Java Utility 
 * See: https://github.com/spdx/tools-java 
 * 
 * The class that helps note down the quantity of energy consumption and the unit used 
 * for measurement. 
 */
public  class EnergyConsumptionDescription extends ModelObjectV3  {

	
	/**
	 * Create the EnergyConsumptionDescription with default model store and generated anonymous ID
	 * @throws InvalidSPDXAnalysisException when unable to create the EnergyConsumptionDescription
	 */
	public EnergyConsumptionDescription() throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore().getNextId(IdType.Anonymous));
	}

	/**
	 * @param objectUri URI or anonymous ID for the EnergyConsumptionDescription
	 * @throws InvalidSPDXAnalysisException when unable to create the EnergyConsumptionDescription
	 */
	public EnergyConsumptionDescription(String objectUri) throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), 
				true, DefaultModelStore.getDefaultDocumentUri() + "#");
	}

	/**
	 * @param modelStore Model store where the EnergyConsumptionDescription is to be stored
	 * @param objectUri URI or anonymous ID for the EnergyConsumptionDescription
	 * @param copyManager Copy manager for the EnergyConsumptionDescription - can be null if copying is not required
	 * @param create true if EnergyConsumptionDescription is to be created
	 * @param idPrefix - prefix to be used when generating new SPDX IDs
	 * @throws InvalidSPDXAnalysisException when unable to create the EnergyConsumptionDescription
	 */
	public EnergyConsumptionDescription(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager,
			boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
		super(modelStore, objectUri, copyManager, create, idPrefix);
	}

	/**
	 * Create the EnergyConsumptionDescription from the builder - used in the builder class
	 * @param builder Builder to create the EnergyConsumptionDescription from
	 * @throws InvalidSPDXAnalysisException when unable to create the EnergyConsumptionDescription
	 */
	protected EnergyConsumptionDescription(EnergyConsumptionDescriptionBuilder builder) throws InvalidSPDXAnalysisException {
		super(builder);
		if (Objects.nonNull(builder.energyUnit)) {
			setEnergyUnit(builder.energyUnit);
		}
		if (Objects.nonNull(builder.energyQuantity)) {
			setEnergyQuantity(builder.energyQuantity);
		}
	}

	/* (non-Javadoc)
	 * @see org.spdx.library.core.CoreModelObject#getType()
	 */
	@Override
	public String getType() {
		return "AI.EnergyConsumptionDescription";
	}
	
	// Getters and Setters
	
	/**
	 * @return the energyUnit
	 */
	public @Nullable EnergyUnitType getEnergyUnit() throws InvalidSPDXAnalysisException {
		Optional<Enum<?>> retval = getEnumPropertyValue(SpdxConstantsV3.PROP_ENERGY_UNIT);
		if (retval.isPresent()) {
			if (!(retval.get() instanceof EnergyUnitType)) {
				throw new InvalidSPDXAnalysisException("Incorrect type stored for energyUnit");
			}
			return (EnergyUnitType)(retval.get());
		} else {
			return null;
		}
	}
	/**
	 * @param energyUnit the energyUnit to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public EnergyConsumptionDescription setEnergyUnit(@Nullable EnergyUnitType energyUnit) throws InvalidSPDXAnalysisException {
		if (isStrict() && Objects.isNull(energyUnit)) {
			throw new InvalidSPDXAnalysisException("energyUnit is a required property");
		}
		setPropertyValue(SpdxConstantsV3.PROP_ENERGY_UNIT, energyUnit);
		return this;
	}
	/**
	 * @return the energyQuantity
	 */
	public @Nullable Integer getEnergyQuantity() throws InvalidSPDXAnalysisException {
		Optional<Integer> retval = getIntegerPropertyValue(SpdxConstantsV3.PROP_ENERGY_QUANTITY);
		return retval.isPresent() ? retval.get() : null;
	}
	
	/**
	 * @param energyQuantity the energyQuantity to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public EnergyConsumptionDescription setEnergyQuantity(@Nullable Integer energyQuantity) throws InvalidSPDXAnalysisException {
		if (isStrict() && Objects.isNull(energyQuantity)) {
			throw new InvalidSPDXAnalysisException("energyQuantity is a required property");
		}
		setPropertyValue(SpdxConstantsV3.PROP_ENERGY_QUANTITY, energyQuantity);
		return this;
	}
	
	
	@Override
	public String toString() {
		return "EnergyConsumptionDescription: "+getObjectUri();
		
	}
	
	/* (non-Javadoc)
	 * @see org.spdx.library.model.v3.ModelObjectV3#_verify(java.util.List)
	 */
	@Override
	public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
		List<String> retval = new ArrayList<>();
		try {
			EnergyUnitType energyUnit = getEnergyUnit();
			if (Objects.isNull(energyUnit) && 
						Collections.disjoint(profiles, Arrays.asList(new ProfileIdentifierType[] { ProfileIdentifierType.AI }))) {
				retval.add("Missing energyUnit in EnergyConsumptionDescription");
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting energyUnit for EnergyConsumptionDescription: "+e.getMessage());
		}
		try {
			Integer energyQuantity = getEnergyQuantity();
			if (Objects.isNull(energyQuantity) &&
					Collections.disjoint(profiles, Arrays.asList(new ProfileIdentifierType[] { ProfileIdentifierType.AI }))) {
				retval.add("Missing energyQuantity in EnergyConsumptionDescription");
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting energyQuantity for EnergyConsumptionDescription: "+e.getMessage());
		}
		return retval;
	}
	
	
	
	public static class EnergyConsumptionDescriptionBuilder extends ModelObjectV3Builder {
	
		/**
		 * Create an EnergyConsumptionDescriptionBuilder from another model object copying the modelStore and copyManager and using an anonymous ID
		 * @param from model object to copy the model store and copyManager from
		 * @throws InvalidSPDXAnalysisException
		 */
		public EnergyConsumptionDescriptionBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
			this(from, from.getModelStore().getNextId(IdType.Anonymous));
		}
	
		/**
		 * Create an EnergyConsumptionDescriptionBuilder from another model object copying the modelStore and copyManager
		 * @param from model object to copy the model store and copyManager from
		 * @param objectUri URI for the object
		 * @throws InvalidSPDXAnalysisException if creationInfo can not be fetched from the from
		 */
		public EnergyConsumptionDescriptionBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
			this(from.getModelStore(), objectUri, from.getCopyManager());
			setStrict(from.isStrict());
			setIdPrefix(from.getIdPrefix());
		}
		
		/**
		 * Creates a EnergyConsumptionDescriptionBuilder
		 * @param modelStore model store for the built EnergyConsumptionDescription
		 * @param objectUri objectUri for the built EnergyConsumptionDescription
		 * @param copyManager optional copyManager for the built EnergyConsumptionDescription
		 */
		public EnergyConsumptionDescriptionBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
			super(modelStore, objectUri, copyManager);
		}
		
		protected EnergyUnitType energyUnit = null;
		protected Integer energyQuantity = null;
		
		
		/**
		 * Sets the initial value of energyUnit
		 * @parameter energyUnit value to set
		 * @return this for chaining
		**/
		public EnergyConsumptionDescriptionBuilder setEnergyUnit(EnergyUnitType energyUnit) {
			this.energyUnit = energyUnit;
			return this;
		}
		
		/**
		 * Sets the initial value of energyQuantity
		 * @parameter energyQuantity value to set
		 * @return this for chaining
		**/
		public EnergyConsumptionDescriptionBuilder setEnergyQuantity(Integer energyQuantity) {
			this.energyQuantity = energyQuantity;
			return this;
		}
	
		/**
		 * @return the EnergyConsumptionDescription
		 * @throws InvalidSPDXAnalysisException on any errors during build
		 */
		public EnergyConsumptionDescription build() throws InvalidSPDXAnalysisException {
			IModelStoreLock lock = getModelStore().enterCriticalSection(false);
			try {
				return new EnergyConsumptionDescription(this);
			} finally {
				getModelStore().leaveCriticalSection(lock);
			}
		}
	}
}
