/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2.license;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.SpdxVerificationHelper;
import org.spdx.library.model.v2.license.AbstractExtractedLicenseInfo;
import org.spdx.licenseTemplate.LicenseTextHelper;
import org.spdx.storage.IModelStore;

public class ExtractedLicenseInfo
extends AbstractExtractedLicenseInfo {
    public static final String UNINITIALIZED_LICENSE_TEXT = "[Initialized with license Parser.  The actual license text is not available]";

    public ExtractedLicenseInfo() throws InvalidSPDXAnalysisException {
        super(DefaultModelStore.getDefaultDocumentUri() + "#" + DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.LicenseRef));
    }

    public ExtractedLicenseInfo(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public ExtractedLicenseInfo(IModelStore modelStore, String documentUri, String id, @Nullable IModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    public ExtractedLicenseInfo(String id, String text) throws InvalidSPDXAnalysisException {
        super(id);
        this.setExtractedText(text);
    }

    public String getType() {
        return "ExtractedLicensingInfo";
    }

    @Override
    public String getExtractedText() throws InvalidSPDXAnalysisException {
        Optional o = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_EXTRACTED_TEXT);
        if (o.isPresent()) {
            return (String)o.get();
        }
        return "";
    }

    public void setExtractedText(String text) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_EXTRACTED_TEXT, text);
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        String id = this.getLicenseId();
        if (id == null || id.isEmpty()) {
            retval.add("Missing required license ID");
        } else {
            String idError = SpdxVerificationHelper.verifyNonStdLicenseId(id);
            if (idError != null && !idError.isEmpty()) {
                retval.add(idError);
            }
        }
        try {
            String licenseText = this.getExtractedText();
            if (licenseText == null || licenseText.isEmpty()) {
                retval.add("Missing required license text for " + id);
            }
            if (UNINITIALIZED_LICENSE_TEXT.equals(licenseText)) {
                retval.add("License not found for " + id);
            }
        }
        catch (InvalidSPDXAnalysisException ex) {
            retval.add("Unable to fetch license text: " + ex.getMessage());
        }
        return retval;
    }

    public boolean equivalent(CoreModelObject compare) throws InvalidSPDXAnalysisException {
        return this.equivalent(compare, false);
    }

    public boolean equivalent(CoreModelObject compare, boolean ignoreRelatedItems) throws InvalidSPDXAnalysisException {
        if (compare instanceof ExtractedLicenseInfo) {
            return LicenseTextHelper.isLicenseTextEquivalent((String)this.getExtractedText(), (String)((ExtractedLicenseInfo)compare).getExtractedText());
        }
        return false;
    }
}

