/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.ModelObjectV2;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.SpdxVerificationHelper;
import org.spdx.library.model.v2.enumerations.ChecksumAlgorithm;
import org.spdx.storage.IModelStore;

public class SpdxPackageVerificationCode
extends ModelObjectV2 {
    public SpdxPackageVerificationCode() throws InvalidSPDXAnalysisException {
    }

    public SpdxPackageVerificationCode(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public SpdxPackageVerificationCode(IModelStore modelStore, String documentUri, String id, @Nullable IModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    public String getType() {
        return "PackageVerificationCode";
    }

    public String getValue() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_VERIFICATIONCODE_VALUE);
        if (retval.isPresent()) {
            return (String)retval.get();
        }
        logger.warn("No value found - returning empty string");
        return "";
    }

    public void setValue(String value) throws InvalidSPDXAnalysisException {
        if (this.strict && (Objects.isNull(value) || value.isEmpty())) {
            throw new InvalidSPDXAnalysisException("Can not set required verification code value to null or empty string");
        }
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_VERIFICATIONCODE_VALUE, value);
    }

    public Collection<String> getExcludedFileNames() throws InvalidSPDXAnalysisException {
        return this.getStringCollection(SpdxConstantsCompatV2.PROP_VERIFICATIONCODE_IGNORED_FILES);
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            String value = this.getValue();
            if (value.isEmpty()) {
                retval.add("Missing required verification code value");
            } else {
                String verify = SpdxVerificationHelper.verifyChecksumString(value, ChecksumAlgorithm.SHA1, specVersion);
                if (verify != null) {
                    retval.add(verify);
                }
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting verification code value: " + e.getMessage());
        }
        return retval;
    }
}

