/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.SpdxElement;
import org.spdx.library.model.v2.Version;
import org.spdx.library.model.v2.license.AnyLicenseInfo;
import org.spdx.library.model.v2.license.SpdxNoAssertionLicense;
import org.spdx.storage.IModelStore;
import org.spdx.storage.PropertyDescriptor;

public abstract class SpdxItem
extends SpdxElement {
    public SpdxItem() throws InvalidSPDXAnalysisException {
    }

    public SpdxItem(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public SpdxItem(IModelStore modelStore, String documentUri, String id, @Nullable IModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    protected PropertyDescriptor getLicenseInfoFromFilesPropertyDescriptor() {
        return SpdxConstantsCompatV2.PROP_PACKAGE_LICENSE_INFO_FROM_FILES;
    }

    public AnyLicenseInfo getLicenseConcluded() throws InvalidSPDXAnalysisException {
        Optional<AnyLicenseInfo> retval = this.getAnyLicenseInfoPropertyValue(SpdxConstantsCompatV2.PROP_LICENSE_CONCLUDED);
        if (retval.isPresent()) {
            return retval.get();
        }
        logger.warn("No license concluded stored, returning NOASSERTION");
        return new SpdxNoAssertionLicense(this.getModelStore(), this.getDocumentUri());
    }

    public SpdxItem setLicenseConcluded(@Nullable AnyLicenseInfo license) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_LICENSE_CONCLUDED, (Object)license);
        return this;
    }

    public Collection<AnyLicenseInfo> getLicenseInfoFromFiles() throws InvalidSPDXAnalysisException {
        return this.getObjectPropertyValueSet(this.getLicenseInfoFromFilesPropertyDescriptor(), AnyLicenseInfo.class);
    }

    public String getCopyrightText() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_COPYRIGHT_TEXT);
        if (retval.isPresent()) {
            return (String)retval.get();
        }
        return "";
    }

    public SpdxItem setCopyrightText(@Nullable String copyrightText) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_COPYRIGHT_TEXT, copyrightText);
        return this;
    }

    public Collection<String> getAttributionText() throws InvalidSPDXAnalysisException {
        return this.getStringCollection(SpdxConstantsCompatV2.PROP_ATTRIBUTION_TEXT);
    }

    @Override
    public SpdxItem setName(String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    public Optional<String> getLicenseComments() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_LIC_COMMENTS);
    }

    public SpdxItem setLicenseComments(String licenseComments) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_LIC_COMMENTS, licenseComments);
        return this;
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        List<String> retval = super._verify(verifiedIds, specVersion);
        String name = "UNKNOWN";
        try {
            Optional<String> myName = this.getName();
            if (myName.isPresent()) {
                name = myName.get();
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting name: " + e.getMessage());
        }
        try {
            Optional<AnyLicenseInfo> concluded = this.getAnyLicenseInfoPropertyValue(SpdxConstantsCompatV2.PROP_LICENSE_CONCLUDED);
            if (!concluded.isPresent()) {
                if (Version.versionLessThan(specVersion, "SPDX-2.3")) {
                    retval.add("Missing required concluded license for " + name);
                }
            } else {
                retval.addAll(concluded.get().verify(verifiedIds, specVersion));
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting license concluded: " + e.getMessage());
        }
        try {
            String copyrightText = this.getCopyrightText();
            if (copyrightText.isEmpty() && Version.versionLessThan(specVersion, "SPDX-2.3")) {
                retval.add("Missing required copyright text for " + name);
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting comment: " + e.getMessage());
        }
        try {
            this.verifyCollection(this.getLicenseInfoFromFiles(), "SPDX Item " + name + " ", verifiedIds, specVersion);
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting license information from files: " + e.getMessage());
        }
        this.addNameToWarnings(retval);
        return retval;
    }
}

